/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import org.robolectric.res.android.CppAssetManager;
import org.robolectric.res.android.SortedVector;
import org.robolectric.res.android.String8;

public class AssetDir {
    private SortedVector<FileInfo> mFileInfo;

    AssetDir() {
        this.mFileInfo = null;
    }

    AssetDir(AssetDir src) {
    }

    public int getFileCount() {
        return this.mFileInfo.size();
    }

    public String8 getFileName(int idx) {
        return this.mFileInfo.itemAt(idx).getFileName();
    }

    void setFileList(SortedVector<FileInfo> list) {
        this.mFileInfo = list;
    }

    static class FileInfo
    implements Comparable<FileInfo> {
        private String8 mFileName;
        private CppAssetManager.FileType mFileType;
        private String8 mSourceName;

        FileInfo() {
        }

        FileInfo(String8 path) {
            this.mFileName = path;
            this.mFileType = CppAssetManager.FileType.kFileTypeUnknown;
        }

        FileInfo(FileInfo src) {
            this.copyMembers(src);
        }

        void copyMembers(FileInfo src) {
            this.mFileName = src.mFileName;
            this.mFileType = src.mFileType;
            this.mSourceName = src.mSourceName;
        }

        void set(String8 path, CppAssetManager.FileType type) {
            this.mFileName = path;
            this.mFileType = type;
        }

        String8 getFileName() {
            return this.mFileName;
        }

        void setFileName(String8 path) {
            this.mFileName = path;
        }

        CppAssetManager.FileType getFileType() {
            return this.mFileType;
        }

        void setFileType(CppAssetManager.FileType type) {
            this.mFileType = type;
        }

        String8 getSourceName() {
            return this.mSourceName;
        }

        void setSourceName(String8 path) {
            this.mSourceName = path;
        }

        public boolean isLessThan(FileInfo fileInfo) {
            return this.mFileName.string().compareTo(fileInfo.mFileName.string()) < 0;
        }

        @Override
        public int compareTo(FileInfo other) {
            return this.mFileName.string().compareTo(other.mFileName.string());
        }

        static int findEntry(SortedVector<FileInfo> pVector, String8 fileName) {
            FileInfo tmpInfo = new FileInfo();
            tmpInfo.setFileName(fileName);
            return pVector.indexOf(tmpInfo);
        }
    }
}

