/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.nativeruntime;

import android.database.CursorWindow;
import android.os.Build;
import com.google.auto.service.AutoService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Priority;
import org.robolectric.pluginapi.NativeRuntimeLoader;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.TempDirectory;
import org.robolectric.util.inject.Injector;

@Priority(value=-2147483648)
@AutoService(value={NativeRuntimeLoader.class})
public class DefaultNativeRuntimeLoader
implements NativeRuntimeLoader {
    protected static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final AtomicReference<NativeRuntimeLoader> nativeRuntimeLoader = new AtomicReference();
    private TempDirectory extractDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void injectAndLoad() {
        AtomicReference<NativeRuntimeLoader> atomicReference = nativeRuntimeLoader;
        synchronized (atomicReference) {
            if (nativeRuntimeLoader.get() == null) {
                Injector injector = new Injector.Builder(CursorWindow.class.getClassLoader()).build();
                NativeRuntimeLoader loader = (NativeRuntimeLoader)injector.getInstance(NativeRuntimeLoader.class);
                nativeRuntimeLoader.set(loader);
            }
        }
        nativeRuntimeLoader.get().ensureLoaded();
    }

    public synchronized void ensureLoaded() {
        if (loaded.get()) {
            return;
        }
        if (!DefaultNativeRuntimeLoader.isSupported()) {
            String errorMessage = String.format("The Robolectric native runtime is not supported on %s (%s)", StandardSystemProperty.OS_NAME.value(), StandardSystemProperty.OS_ARCH.value());
            throw new AssertionError((Object)errorMessage);
        }
        loaded.set(true);
        try {
            PerfStatsCollector.getInstance().measure("loadNativeRuntime", () -> {
                this.extractDirectory = new TempDirectory("nativeruntime");
                System.setProperty("robolectric.nativeruntime.languageTag", Locale.getDefault().toLanguageTag());
                if (Build.VERSION.SDK_INT >= 26) {
                    this.maybeCopyFonts(this.extractDirectory);
                }
                this.maybeCopyIcuData(this.extractDirectory);
                this.loadLibrary(this.extractDirectory);
            });
        }
        catch (IOException e) {
            throw new AssertionError("Unable to load Robolectric native runtime library", e);
        }
    }

    private void maybeCopyIcuData(TempDirectory tempDirectory) throws IOException {
        URL icuDatUrl;
        try {
            icuDatUrl = Resources.getResource((String)"icu/icudt68l.dat");
        }
        catch (IllegalArgumentException e) {
            return;
        }
        Path icuPath = tempDirectory.create("icu");
        Path icuDatPath = tempDirectory.getBasePath().resolve("icu/icudt68l.dat");
        Resources.asByteSource((URL)icuDatUrl).copyTo(com.google.common.io.Files.asByteSink((File)icuDatPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.setProperty("icu.dir", icuPath.toAbsolutePath().toString());
    }

    private void maybeCopyFonts(TempDirectory tempDirectory) throws IOException {
        URI fontsUri = null;
        try {
            fontsUri = Resources.getResource((String)"fonts/").toURI();
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            return;
        }
        FileSystem zipfs = null;
        if ("jar".equals(fontsUri.getScheme())) {
            zipfs = FileSystems.newFileSystem(fontsUri, ImmutableMap.of((Object)"create", (Object)"true"));
        }
        Path fontsInputPath = Paths.get(fontsUri);
        Path fontsOutputPath = tempDirectory.create("fonts");
        try (Stream<Path> pathStream = Files.walk(fontsInputPath, new FileVisitOption[0]);){
            Iterator fileIterator = pathStream.iterator();
            while (fileIterator.hasNext()) {
                Path path = (Path)fileIterator.next();
                if ("fonts".equals(path.getFileName().toString())) continue;
                String fontPath = "fonts/" + path.getFileName();
                URL resource = Resources.getResource((String)fontPath);
                Path outputPath = tempDirectory.getBasePath().resolve(fontPath);
                Resources.asByteSource((URL)resource).copyTo(com.google.common.io.Files.asByteSink((File)outputPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
            }
        }
        System.setProperty("robolectric.nativeruntime.fontdir", fontsOutputPath.toAbsolutePath() + File.separator);
        if (zipfs != null) {
            zipfs.close();
        }
    }

    private void loadLibrary(TempDirectory tempDirectory) throws IOException {
        String libraryName = System.mapLibraryName("robolectric-nativeruntime");
        System.setProperty("robolectric.nativeruntime.languageTag", Locale.getDefault().toLanguageTag());
        Path libraryPath = tempDirectory.getBasePath().resolve(libraryName);
        URL libraryResource = Resources.getResource((String)DefaultNativeRuntimeLoader.nativeLibraryPath());
        Resources.asByteSource((URL)libraryResource).copyTo(com.google.common.io.Files.asByteSink((File)libraryPath.toFile(), (FileWriteMode[])new FileWriteMode[0]));
        System.load(libraryPath.toAbsolutePath().toString());
    }

    private static boolean isSupported() {
        return "mac".equals(DefaultNativeRuntimeLoader.osName()) && ("aarch64".equals(DefaultNativeRuntimeLoader.arch()) || "x86_64".equals(DefaultNativeRuntimeLoader.arch())) || "linux".equals(DefaultNativeRuntimeLoader.osName()) && "x86_64".equals(DefaultNativeRuntimeLoader.arch()) || "windows".equals(DefaultNativeRuntimeLoader.osName()) && "x86_64".equals(DefaultNativeRuntimeLoader.arch());
    }

    private static String nativeLibraryPath() {
        String os = DefaultNativeRuntimeLoader.osName();
        String arch = DefaultNativeRuntimeLoader.arch();
        return String.format("native/%s/%s/%s", os, arch, System.mapLibraryName("robolectric-nativeruntime"));
    }

    private static String osName() {
        String osName = StandardSystemProperty.OS_NAME.value().toLowerCase(Locale.US);
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        if (osName.contains("win")) {
            return "windows";
        }
        return "unknown";
    }

    private static String arch() {
        String arch = StandardSystemProperty.OS_ARCH.value().toLowerCase(Locale.US);
        if (arch.equals("x86_64") || arch.equals("amd64")) {
            return "x86_64";
        }
        return arch;
    }

    @VisibleForTesting
    static boolean isLoaded() {
        return loaded.get();
    }

    @VisibleForTesting
    Path getDirectory() {
        return this.extractDirectory == null ? null : this.extractDirectory.getBasePath();
    }

    @VisibleForTesting
    static void resetLoaded() {
        loaded.set(false);
    }
}

