/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.RoaringArray;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;

public final class RangeBitmap {
    private static final int COOKIE = 61453;
    private static final int BITMAP = 0;
    private static final int RUN = 1;
    private static final int ARRAY = 2;
    private static final int BITMAP_SIZE = 8192;
    private final ByteBuffer buffer;
    private final int masksOffset;
    private final int containersOffset;
    private final long mask;
    private final long max;

    public static Appender appender(long maxValue, IntFunction<ByteBuffer> bufferSupplier, Consumer<ByteBuffer> cleaner) {
        return new Appender(maxValue, bufferSupplier, cleaner);
    }

    public static Appender appender(long maxValue) {
        return RangeBitmap.appender(maxValue, capacity -> ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN), b -> {});
    }

    public static RangeBitmap map(ByteBuffer buffer) {
        ByteBuffer source = buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        char cookie = source.getChar();
        if (cookie != '\uf00d') {
            throw new InvalidRoaringFormat("invalid cookie for range bitmap (expected 61453 but got " + cookie + ")");
        }
        int base = source.get() & 0xFF;
        if (base != 2) {
            throw new InvalidRoaringFormat("Unsupported base for range bitmap: " + cookie);
        }
        int sliceCount = source.get() & 0xFF;
        char maxKey = source.getChar();
        long mask = sliceCount == 64 ? -1L : (1L << sliceCount) - 1L;
        long maxRid = (long)source.getInt() & 0xFFFFFFFFL;
        int masksOffset = source.position();
        int containersOffset = masksOffset + maxKey * (sliceCount >>> 3);
        return new RangeBitmap(mask, maxRid, (ByteBuffer)source.position(buffer.position()), masksOffset, containersOffset);
    }

    RangeBitmap(long mask, long max, ByteBuffer buffer, int masksOffset, int containersOffset) {
        this.mask = mask;
        this.max = max;
        this.buffer = buffer;
        this.masksOffset = masksOffset;
        this.containersOffset = containersOffset;
    }

    public RoaringBitmap lte(long threshold) {
        return this.evaluateRange(threshold, true);
    }

    public RoaringBitmap lte(long threshold, RoaringBitmap context) {
        return this.evaluateRange(threshold, true, context);
    }

    public RoaringBitmap lt(long threshold) {
        return threshold == 0L ? new RoaringBitmap() : this.lte(threshold - 1L);
    }

    public RoaringBitmap lt(long threshold, RoaringBitmap context) {
        return threshold == 0L ? new RoaringBitmap() : this.lte(threshold - 1L, context);
    }

    public RoaringBitmap gt(long threshold) {
        return this.evaluateRange(threshold, false);
    }

    public RoaringBitmap gt(long threshold, RoaringBitmap context) {
        return this.evaluateRange(threshold, false, context);
    }

    public RoaringBitmap gte(long threshold) {
        return threshold == 0L ? RoaringBitmap.bitmapOfRange(0L, this.max) : this.gt(threshold - 1L);
    }

    public RoaringBitmap gte(long threshold, RoaringBitmap context) {
        return threshold == 0L ? context.clone() : this.gt(threshold - 1L, context);
    }

    private RoaringBitmap evaluateRange(long threshold, boolean upper) {
        if (Long.numberOfLeadingZeros(threshold) < Long.numberOfLeadingZeros(this.mask)) {
            return upper ? RoaringBitmap.bitmapOfRange(0L, this.max) : new RoaringBitmap();
        }
        ByteBuffer containers = this.buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        containers.position(this.containersOffset);
        RoaringArray output = new RoaringArray();
        long[] bits = new long[1024];
        long remaining = this.max;
        int mPos = this.masksOffset;
        char key = '\u0000';
        boolean empty = true;
        while (remaining > 0L) {
            Container toAppend;
            long containerMask = this.buffer.getLong(mPos) & this.mask;
            empty = this.evaluateHorizontalSlice(containers, remaining, threshold, containerMask, empty, bits);
            if (!upper) {
                Util.flipBitmapRange(bits, 0, Math.min(65536, (int)remaining));
                empty = false;
            }
            if (!empty && !(toAppend = new BitmapContainer(bits, -1).repairAfterLazy().runOptimize()).isEmpty()) {
                output.append(key, toAppend instanceof BitmapContainer ? toAppend.clone() : toAppend);
            }
            key = (char)(key + 1);
            remaining -= 65536L;
            mPos += Long.bitCount(this.mask) >>> 3;
        }
        return new RoaringBitmap(output);
    }

    private RoaringBitmap evaluateRange(long threshold, boolean upper, RoaringBitmap context) {
        if (context.isEmpty()) {
            return new RoaringBitmap();
        }
        if (Long.numberOfLeadingZeros(threshold) < Long.numberOfLeadingZeros(this.mask)) {
            return upper ? RoaringBitmap.bitmapOfRange(0L, this.max) : new RoaringBitmap();
        }
        ByteBuffer containers = this.buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        containers.position(this.containersOffset);
        RoaringArray contextArray = context.highLowContainer;
        int contextPos = 0;
        int maxContextKey = contextArray.keys[contextArray.size - 1];
        RoaringArray output = new RoaringArray();
        long[] bits = new long[1024];
        long remaining = this.max;
        int mPos = this.masksOffset;
        boolean empty = true;
        for (int prefix = 0; prefix <= maxContextKey && remaining > 0L; ++prefix) {
            long containerMask = this.buffer.getLong(mPos) & this.mask;
            if (prefix < contextArray.keys[contextPos]) {
                for (int i = 0; i < Long.bitCount(containerMask); ++i) {
                    RangeBitmap.skipContainer(containers);
                }
            } else {
                Container toAppend;
                empty = this.evaluateHorizontalSlice(containers, remaining, threshold, containerMask, empty, bits);
                if (!upper) {
                    Util.flipBitmapRange(bits, 0, Math.min(65536, (int)remaining));
                    empty = false;
                }
                if (!empty && !(toAppend = new BitmapContainer(bits, -1).iand(contextArray.values[contextPos]).repairAfterLazy().runOptimize()).isEmpty()) {
                    output.append((char)prefix, toAppend instanceof BitmapContainer ? toAppend.clone() : toAppend);
                }
                ++contextPos;
            }
            remaining -= 65536L;
            mPos += Long.bitCount(this.mask) >>> 3;
        }
        return new RoaringBitmap(output);
    }

    private boolean evaluateHorizontalSlice(ByteBuffer containers, long remaining, long threshold, long containerMask, boolean empty, long[] bits) {
        int slice;
        int skip = 64 - Long.numberOfLeadingZeros((threshold ^ 0xFFFFFFFFFFFFFFFFL) & (containerMask ^ 0xFFFFFFFFFFFFFFFFL) & this.mask);
        if (skip > 0) {
            for (slice = 0; slice < skip; ++slice) {
                if ((containerMask >>> slice & 1L) != 1L) continue;
                RangeBitmap.skipContainer(containers);
            }
            if (!empty) {
                Arrays.fill(bits, 0L);
                empty = true;
            }
        } else {
            if ((threshold & 1L) == 1L) {
                if (remaining >= 65536L) {
                    Arrays.fill(bits, -1L);
                } else {
                    Util.setBitmapRange(bits, 0, (int)remaining);
                    if (!empty) {
                        Util.resetBitmapRange(bits, (int)remaining, 65536);
                    }
                }
                if ((containerMask & 1L) == 1L) {
                    RangeBitmap.skipContainer(containers);
                }
                empty = false;
            } else {
                if (!empty) {
                    Arrays.fill(bits, 0L);
                    empty = true;
                }
                if ((containerMask & 1L) == 1L) {
                    if ((threshold & 1L) == 0L) {
                        RangeBitmap.nextContainer(containers).orInto(bits);
                        empty = false;
                    } else {
                        RangeBitmap.skipContainer(containers);
                    }
                }
            }
            ++slice;
        }
        while (slice < Long.bitCount(this.mask)) {
            if ((containerMask >>> slice & 1L) == 1L) {
                if ((threshold >>> slice & 1L) == 1L) {
                    RangeBitmap.nextContainer(containers).orInto(bits);
                    empty = false;
                } else if (empty) {
                    RangeBitmap.skipContainer(containers);
                } else {
                    RangeBitmap.nextContainer(containers).andInto(bits);
                }
            }
            ++slice;
        }
        return empty;
    }

    private static MappeableContainer nextContainer(ByteBuffer buffer) {
        byte type = buffer.get();
        int size = buffer.getChar() & 0xFFFF;
        if (type == 0) {
            LongBuffer lb = ((ByteBuffer)buffer.slice().order(ByteOrder.LITTLE_ENDIAN).limit(8192)).asLongBuffer();
            buffer.position(buffer.position() + 8192);
            return new MappeableBitmapContainer(lb, size);
        }
        int skip = size << (type == 1 ? 2 : 1);
        CharBuffer cb = ((ByteBuffer)buffer.slice().order(ByteOrder.LITTLE_ENDIAN).limit(skip)).asCharBuffer();
        buffer.position(buffer.position() + skip);
        return type == 1 ? new MappeableRunContainer(cb, size) : new MappeableArrayContainer(cb, size);
    }

    private static void skipContainer(ByteBuffer buffer) {
        byte type = buffer.get();
        int size = buffer.getChar() & 0xFFFF;
        if (type == 0) {
            buffer.position(buffer.position() + 8192);
        } else {
            int skip = size << (type == 1 ? 2 : 1);
            buffer.position(buffer.position() + skip);
        }
    }

    public static final class Appender {
        private static final int GROWTH = 8;
        private final IntFunction<ByteBuffer> bufferSupplier;
        private final Consumer<ByteBuffer> bufferCleaner;
        private final long rangeMask;
        private final Container[] slice;
        private ByteBuffer maskBuffer;
        private ByteBuffer containers;
        private int bufferPos;
        private long mask;
        private int rid;
        private int key = 0;
        private int serializedContainerSize;

        Appender(long maxValue, IntFunction<ByteBuffer> bufferSupplier, Consumer<ByteBuffer> cleaner) {
            this.bufferSupplier = bufferSupplier;
            this.bufferCleaner = cleaner;
            this.rangeMask = Appender.rangeMaxForLimit(maxValue);
            this.slice = new Container[Long.bitCount(this.rangeMask)];
            for (int i = 0; i < this.slice.length; ++i) {
                this.slice[i] = this.containerForSlice(i);
            }
            this.maskBuffer = bufferSupplier.apply(this.maskBufferGrowth());
            this.containers = bufferSupplier.apply(this.containerGrowth() * 1024);
        }

        public RangeBitmap build(IntFunction<ByteBuffer> supplier) {
            this.flush();
            return this.build(supplier.apply(this.serializedSizeInBytes()));
        }

        public RangeBitmap build() {
            return this.build((int capacity) -> ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN));
        }

        public RangeBitmap build(ByteBuffer buffer) {
            this.serialize(buffer);
            buffer.flip();
            return RangeBitmap.map(buffer);
        }

        public void clear() {
            this.containers.position(0);
            this.bufferPos = 0;
            this.mask = 0L;
            this.rid = 0;
            this.key = 0;
            this.serializedContainerSize = 0;
        }

        public int serializedSizeInBytes() {
            this.flush();
            int cookieSize = 2;
            int baseSize = 1;
            int slicesSize = 1;
            int maxKeySize = 2;
            int maxRidSize = 4;
            int headerSize = cookieSize + baseSize + slicesSize + maxKeySize + maxRidSize;
            int keysSize = this.key * (Long.bitCount(this.rangeMask) >>> 3);
            return headerSize + keysSize + this.serializedContainerSize;
        }

        public void serialize(ByteBuffer buffer) {
            if (this.flush()) {
                throw new IllegalStateException("Attempted to serialize without calling serializedSizeInBytes first");
            }
            ByteBuffer target = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
            target.putChar('\uf00d');
            target.put((byte)2);
            target.put((byte)Long.bitCount(this.rangeMask));
            target.putChar((char)this.key);
            target.putInt(this.rid);
            int spaceForKeys = this.key * (Long.bitCount(this.rangeMask) >>> 3);
            target.put((ByteBuffer)this.maskBuffer.slice().order(ByteOrder.LITTLE_ENDIAN).limit(spaceForKeys));
            target.put((ByteBuffer)this.containers.slice().order(ByteOrder.LITTLE_ENDIAN).limit(this.serializedContainerSize));
            if (buffer != target) {
                buffer.position(target.position());
            }
        }

        public void add(long value) {
            if ((value & this.rangeMask) == value) {
                long bits;
                this.mask |= bits;
                for (bits = (value ^ 0xFFFFFFFFFFFFFFFFL) & this.rangeMask; bits != 0L; bits &= bits - 1L) {
                    int index = Long.numberOfTrailingZeros(bits);
                    Container c = this.slice[index];
                    Container updated = c.add((char)this.rid);
                    if (updated == c) continue;
                    this.slice[index] = updated;
                }
            } else {
                throw new IllegalArgumentException(value + " too large");
            }
            ++this.rid;
            if (this.rid >>> 16 > this.key) {
                this.append();
            }
        }

        private boolean flush() {
            if (this.mask != 0L) {
                this.append();
                return true;
            }
            return false;
        }

        private void append() {
            if (this.maskBuffer.capacity() - this.bufferPos < 8) {
                this.maskBuffer = this.growBuffer(this.maskBuffer, this.maskBufferGrowth());
                this.maskBuffer.position(0);
            }
            int maskWidth = Long.bitCount(this.rangeMask);
            this.maskBuffer.putLong(this.bufferPos, this.mask);
            this.bufferPos += maskWidth >>> 3;
            for (Container container : this.slice) {
                if (container.isEmpty()) continue;
                Container toSerialize = container.runOptimize();
                int serializedSize = toSerialize.serializedSizeInBytes();
                int type = toSerialize instanceof BitmapContainer ? 0 : (toSerialize instanceof RunContainer ? 1 : 2);
                int required = serializedSize + (type == 0 ? 3 : 1);
                if (this.containers.capacity() - this.serializedContainerSize < required) {
                    this.containers = this.growBuffer(this.containers, this.containerGrowth() * 1024);
                }
                this.containers.put(this.serializedContainerSize, (byte)type);
                if (type == 0) {
                    this.containers.putChar(this.serializedContainerSize + 1, (char)container.getCardinality());
                    this.containers.position(this.serializedContainerSize + 3);
                    toSerialize.writeArray(this.containers);
                    this.containers.position(0);
                    this.serializedContainerSize += required;
                } else if (type == 1) {
                    this.containers.position(this.serializedContainerSize + 1);
                    toSerialize.writeArray(this.containers);
                    this.containers.position(0);
                    this.serializedContainerSize += required;
                } else {
                    this.containers.putChar(this.serializedContainerSize + 1, (char)container.getCardinality());
                    this.containers.position(this.serializedContainerSize + 3);
                    toSerialize.writeArray(this.containers);
                    this.containers.position(0);
                    this.serializedContainerSize += required;
                }
                container.clear();
            }
            this.mask = 0L;
            ++this.key;
        }

        private int maskBufferGrowth() {
            return 8 * (Long.bitCount(this.rangeMask) >>> 3);
        }

        private int containerGrowth() {
            return 8 * this.slice.length;
        }

        private ByteBuffer growBuffer(ByteBuffer buffer, int growth) {
            ByteBuffer newBuffer = this.bufferSupplier.apply(buffer.capacity() + growth);
            int pos = buffer.position();
            newBuffer.put(buffer);
            buffer.position(pos);
            this.bufferCleaner.accept(buffer);
            return newBuffer;
        }

        private Container containerForSlice(int sliceNumber) {
            if (sliceNumber >= 5) {
                return new RunContainer();
            }
            return new BitmapContainer();
        }

        private static long rangeMaxForLimit(long maxValue) {
            int lz = Long.numberOfLeadingZeros(maxValue | 1L);
            return lz <= 8 ? -1L : (1L << (64 - lz + 7 & 0xFFFFFFF8)) - 1L;
        }
    }
}

