/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.bpel.console;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRef;
import org.jboss.bpm.console.client.model.ProcessDefinitionRef;
import org.jboss.bpm.console.server.plugin.ProcessHistoryPlugin;
import org.jboss.bpm.monitor.model.BPAFDataSource;
import org.jboss.bpm.monitor.model.DefaultBPAFDataSource;
import org.jboss.bpm.monitor.model.bpaf.Event;
import org.jboss.bpm.monitor.model.bpaf.State;
import org.jboss.bpm.monitor.model.bpaf.Tuple;
import org.jboss.bpm.monitor.model.json.XYDataSetJSO;
import org.jboss.bpm.monitor.model.metric.Grouping;
import org.jboss.bpm.monitor.model.metric.Timespan;
import org.jboss.bpm.monitor.model.metric.TimespanFactory;
import org.jboss.soa.bpel.console.ModelAdaptor;
import org.riftsaw.engine.BPELEngine;
import org.riftsaw.engine.BPELEngineFactory;

public class ProcessHistoryPluginImpl
implements ProcessHistoryPlugin {
    private BPAFDataSource ds = null;
    private BPELEngine engine = null;

    public ProcessHistoryPluginImpl() {
        try {
            this.engine = BPELEngineFactory.getEngine();
            InitialContext ctx = new InitialContext();
            EntityManagerFactory emf = (EntityManagerFactory)ctx.lookup("java:jboss/BPELEMFactory");
            if (null == emf) {
                throw new IllegalStateException("EntityManagerFactory is null");
            }
            this.ds = new DefaultBPAFDataSource(emf);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize BPAF datasource or BPEL Engine", e);
        }
    }

    public List<HistoryProcessInstanceRef> getHistoryProcessInstances(String definitionkey, String status, long starttime, long endtime, String correlationkey) {
        String dkey = ModelAdaptor.decodeId(definitionkey);
        List events = this.ds.getInstanceEvents(dkey, new Timespan(starttime, endtime, "Custom"), this.getStatus(status));
        List instanceIds = null;
        if (correlationkey != null && !"".equals(correlationkey.trim())) {
            String ckey = null;
            try {
                ckey = URLDecoder.decode(correlationkey.replace("~", "="), "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new IllegalStateException("Decode correlation key of " + correlationkey + " failed.");
            }
            instanceIds = this.ds.getProcessInstances(dkey, "correlation-key", ckey);
        }
        HashSet<String> historyInstanceIds = new HashSet<String>();
        for (Event e : events) {
            if (instanceIds != null && !instanceIds.contains(e.getProcessInstanceID()) || !e.getEventDetails().getCurrentState().equals((Object)this.getStatus(status))) continue;
            historyInstanceIds.add(e.getProcessInstanceID());
        }
        ArrayList<HistoryProcessInstanceRef> refs = new ArrayList<HistoryProcessInstanceRef>();
        for (String theInstanceID : historyInstanceIds) {
            List theEvents = this.ds.getPastActivities(theInstanceID);
            HistoryProcessInstanceRef ref = new HistoryProcessInstanceRef();
            for (Event e : theEvents) {
                ref.setProcessInstanceId(e.getProcessInstanceID());
                ref.setState(status);
                ref.setProcessDefinitionId(e.getProcessDefinitionID());
                for (Tuple tuple : e.getDataElement()) {
                    if ("correlation-key".equals(tuple.getName())) {
                        ref.setKey(tuple.getValue());
                    }
                    if ("process-start-time".equals(tuple.getName())) {
                        ref.setStartTime(new Date(new Long(tuple.getValue())));
                    }
                    if (!"process-end-time".equals(tuple.getName())) continue;
                    ref.setEndTime(new Date(new Long(tuple.getValue())));
                }
            }
            refs.add(ref);
        }
        return refs;
    }

    public List<ProcessDefinitionRef> getProcessDefinitions() {
        ArrayList<ProcessDefinitionRef> refs = new ArrayList<ProcessDefinitionRef>();
        List keys = this.ds.getProcessDefinitions();
        for (String id : keys) {
            ProcessDefinitionRef ref = new ProcessDefinitionRef();
            ref.setName(id);
            ref.setId(ModelAdaptor.encodeId(id));
            refs.add(ref);
        }
        return refs;
    }

    public List<String> getProcessInstanceKeys(String definitionId) {
        String decodedId = ModelAdaptor.decodeId(definitionId);
        return this.ds.getProcessInstances(decodedId);
    }

    public List<String> getActivityKeys(String instanceId) {
        return this.ds.getActivityDefinitions(instanceId);
    }

    public List<String> getAllEvents(String instanceId) {
        List events = this.ds.getPastActivities(instanceId);
        LinkedList<String> result = new LinkedList<String>();
        for (Event event : events) {
            for (Tuple tuple : event.getDataElement()) {
                if (!"data".equals(tuple.getName())) continue;
                result.add(tuple.getValue());
            }
        }
        return result;
    }

    public Set<String> getCompletedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Completed);
    }

    public Set<String> getFailedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Completed_Failed);
    }

    public Set<String> getTerminatedInstances(String definitionKey, long timestamp, String timespan) {
        return this.getInstances(definitionKey, timestamp, timespan, State.Closed_Cancelled_Terminated);
    }

    public String getCompletedInstances4Chart(String processDefinition, String timespanValue) {
        Timespan timespan = TimespanFactory.fromValue((String)timespanValue);
        String decodedId = ModelAdaptor.decodeId(processDefinition);
        List events = this.ds.getInstanceEvents(decodedId, timespan, State.Closed_Completed);
        return ProcessHistoryPluginImpl.createDatasetJSO(new String[]{"Completed"}, timespan, true, events);
    }

    public String getFailedInstances4Chart(String processDefinition, String timespanValue) {
        Timespan timespan = TimespanFactory.fromValue((String)timespanValue);
        String decodedId = ModelAdaptor.decodeId(processDefinition);
        List completed = this.ds.getInstanceEvents(decodedId, timespan, State.Closed_Completed);
        List failed = this.ds.getInstanceEvents(decodedId, timespan, State.Closed_Completed_Failed);
        List terminated = this.ds.getInstanceEvents(decodedId, timespan, State.Closed_Cancelled_Terminated);
        return ProcessHistoryPluginImpl.createDatasetJSO(new String[]{"Completed", "Failed", "Terminated"}, timespan, true, completed, failed, terminated);
    }

    private Set<String> getInstances(String definitionKey, long timestamp, String timespan, State completionState) {
        String decodedId = ModelAdaptor.decodeId(definitionKey);
        HashSet<String> instanceIds = new HashSet<String>();
        Timespan chartTimespan = TimespanFactory.fromValue((String)timespan);
        long[] bounds = TimespanFactory.getLeftBounds((Timespan)chartTimespan, (Date)new Date(timestamp));
        List events = this.ds.getInstanceEvents(decodedId, new Timespan(bounds[0], bounds[1], chartTimespan.getUnit(), "custom"), completionState);
        for (Event e : events) {
            if (!e.getEventDetails().getCurrentState().equals((Object)completionState)) continue;
            instanceIds.add(e.getProcessInstanceID());
        }
        HashSet<String> result = new HashSet<String>();
        for (String instanceId : instanceIds) {
            List theEvents = this.ds.getPastActivities(instanceId);
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Instance Id: " + instanceId + " ");
            this.addCorrelationInformation(theEvents, sbuffer);
            result.add(sbuffer.toString());
        }
        return result;
    }

    private void addCorrelationInformation(List<Event> theEvents, StringBuffer sbuffer) {
        for (Event theEvent : theEvents) {
            if (!"CORRELATION_SET_WRITE".equals(theEvent.getActivityName())) continue;
            for (Tuple tuple : theEvent.getDataElement()) {
                if (!"correlation-key".equals(tuple.getName())) continue;
                sbuffer.append(" Correlation key: ");
                sbuffer.append(tuple.getValue());
            }
        }
    }

    private State getStatus(String status) {
        if ("COMPLETED".equalsIgnoreCase(status)) {
            return State.Closed_Completed;
        }
        if ("FAILED".equalsIgnoreCase(status)) {
            return State.Closed_Completed_Failed;
        }
        if ("TERMINATED".equalsIgnoreCase(status)) {
            return State.Closed_Cancelled_Terminated;
        }
        return null;
    }

    private static String createDatasetJSO(String[] title, Timespan timespan, boolean matchParity, List<Event> ... events) {
        XYDataSetJSO dataSet = new XYDataSetJSO(title, UUID.randomUUID().toString());
        for (List<Event> subset : events) {
            SortedMap<Date, List<Event>> grouped = ProcessHistoryPluginImpl.group(timespan, subset);
            ArrayList<Long> domainData = new ArrayList<Long>(grouped.size());
            ArrayList<Long> rangeData = new ArrayList<Long>(grouped.size());
            for (Date d : grouped.keySet()) {
                domainData.add(d.getTime());
                int actualSize = matchParity ? ((List)grouped.get(d)).size() / 2 : ((List)grouped.get(d)).size();
                rangeData.add(new Integer(actualSize).longValue());
            }
            dataSet.getDomain().add(domainData);
            dataSet.getRange().add(rangeData);
        }
        dataSet.setAxis("date");
        return dataSet.toJSO();
    }

    private static SortedMap<Date, List<Event>> group(Timespan timespan, List<Event> events) {
        SortedMap grouped;
        switch (timespan.getUnit()) {
            case HOUR: {
                grouped = Grouping.byHour(events, (Timespan)timespan);
                break;
            }
            case DAY: {
                grouped = Grouping.byDay(events, (Timespan)timespan);
                break;
            }
            case WEEK: {
                grouped = Grouping.byWeek(events, (Timespan)timespan);
                break;
            }
            case MONTH: {
                grouped = Grouping.byMonth(events, (Timespan)timespan);
                break;
            }
            default: {
                throw new IllegalArgumentException("UNIT not supported: " + timespan.getUnit());
            }
        }
        return grouped;
    }

    public boolean recoveryAction(String iid, String aid, String action) {
        boolean result = true;
        try {
            this.engine.getManagementInterface().recoverActivity(Long.valueOf(iid), Long.valueOf(aid), action);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }
}

