/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.ElseIfInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.IfInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ElseIfImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ElseImpl;

public class IfImpl
extends ActivityImpl
implements IfInterface {
    private SVGDimension coreDimensions = null;
    private SVGDimension conditionalDimensions = null;

    public IfImpl(String token) {
        super(token);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public IfImpl(OMElement omElement) {
        super(omElement);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public IfImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    protected int getElseIfAdjustment() {
        int adjustment = 0;
        adjustment = this.layoutManager.isVerticalLayout() ? this.getStartIconHeight() + this.getYSpacing() : this.getStartIconWidth() + this.getYSpacing();
        return adjustment;
    }

    @Override
    public String getId() {
        return this.getName();
    }

    @Override
    public String getEndTag() {
        return "/if";
    }

    @Override
    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            int coreWidth = 0;
            int coreHeight = 0;
            int conWidth = 0;
            int conHeight = 0;
            this.dimensions = new SVGDimension(coreWidth, coreHeight);
            this.coreDimensions = new SVGDimension(coreWidth, coreHeight);
            this.conditionalDimensions = new SVGDimension(conWidth, conHeight);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (activity2 instanceof ElseIfImpl || activity2 instanceof ElseImpl) {
                    if (subActivityDim.getHeight() > conHeight) {
                        conHeight += subActivityDim.getHeight();
                    }
                    conWidth += subActivityDim.getWidth();
                    continue;
                }
                if (subActivityDim.getWidth() > coreWidth) {
                    coreWidth += subActivityDim.getWidth();
                }
                coreHeight += subActivityDim.getHeight();
            }
            this.coreDimensions.setHeight(coreHeight += this.getYSpacing() + this.getStartIconHeight() + this.getEndIconHeight());
            this.coreDimensions.setWidth(coreWidth);
            this.conditionalDimensions.setHeight(conHeight += this.getElseIfAdjustment());
            this.conditionalDimensions.setWidth(conWidth);
            height = coreHeight > conHeight ? coreHeight : conHeight;
            width = coreWidth + conWidth;
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing());
        }
        return this.dimensions;
    }

    public SVGDimension getCoreDimensions() {
        return this.coreDimensions;
    }

    public SVGDimension getConditionalDimensions() {
        return this.conditionalDimensions;
    }

    @Override
    public void switchDimensionsToHorizontal() {
        super.switchDimensionsToHorizontal();
        int height = 0;
        int width = 0;
        height = this.coreDimensions.getHeight();
        width = this.coreDimensions.getWidth();
        this.coreDimensions.setHeight(width);
        this.coreDimensions.setWidth(height);
        height = this.conditionalDimensions.getHeight();
        width = this.conditionalDimensions.getWidth();
        this.conditionalDimensions.setHeight(width);
        this.conditionalDimensions.setWidth(height);
    }

    private boolean isSimpleLayout() {
        boolean simple = true;
        ActivityInterface activity2 = null;
        for (ActivityInterface activity2 : this.getSubActivities()) {
            if (!(activity2 instanceof ElseIfImpl) && !(activity2 instanceof ElseImpl)) continue;
            simple = false;
            break;
        }
        return simple;
    }

    @Override
    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        int endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
        int endYTop = startYTop + this.dimensions.getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        int centerNHLayout = startXLeft + this.coreDimensions.getWidth() / 2;
        if (this.isSimpleLayout()) {
            xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
            endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
        } else {
            xLeft = centerNHLayout - this.getStartIconWidth() / 2 + this.getXSpacing() / 2;
            endXLeft = centerNHLayout - this.getEndIconWidth() / 2 + this.getXSpacing() / 2;
        }
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = yTop + this.getStartIconHeight() + this.getYSpacing() / 2;
        int childXLeft = startXLeft + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            if (activity instanceof ElseIfImpl || activity instanceof ElseImpl) continue;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        itr = this.getSubActivities().iterator();
        childXLeft = startXLeft + this.coreDimensions.getWidth();
        childYTop = yTop + this.getElseIfAdjustment();
        while (itr.hasNext()) {
            activity = itr.next();
            if (!(activity instanceof ElseIfImpl) && !(activity instanceof ElseImpl)) continue;
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    private void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        int endXLeft = startXLeft + this.dimensions.getWidth() - this.getEndIconWidth() - this.getYSpacing() / 2;
        int endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
        int centerNHLayout = startYTop + this.coreDimensions.getHeight() / 2;
        if (this.isSimpleLayout()) {
            yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
            endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
        } else {
            yTop = centerNHLayout - this.getStartIconHeight() / 2;
            endYTop = centerNHLayout - this.getEndIconHeight() / 2;
        }
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childXLeft = xLeft + this.getStartIconWidth() + this.getYSpacing() / 2;
        int childYTop = startYTop + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            if (activity instanceof ElseIfImpl || activity instanceof ElseImpl) continue;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        itr = this.getSubActivities().iterator();
        childYTop = startYTop + this.coreDimensions.getHeight();
        childXLeft = xLeft + this.getElseIfAdjustment();
        while (itr.hasNext()) {
            activity = itr.next();
            if (!(activity instanceof ElseIfImpl) && !(activity instanceof ElseImpl)) continue;
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    @Override
    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop();
        } else {
            xLeft = this.getStartIconXLeft();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    @Override
    public SVGCoordinates getExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop() + this.getEndIconHeight();
        } else {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartIconExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getEndIconEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop();
        } else {
            xLeft = this.getEndIconXLeft();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    protected SVGCoordinates getStartIconElseArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth();
            yTop = this.getStartIconYTop() + this.getStartIconHeight() / 2;
        } else {
            xLeft = this.getStartIconXLeft() + this.getStartIconWidth() / 2;
            yTop = this.getStartIconYTop() + this.getStartIconHeight();
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    @Override
    public Element getSVGString(SVGDocument doc) {
        Element group1 = null;
        group1 = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group1.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group1.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group1.appendChild(this.getBoxDefinition(doc));
        group1.appendChild(this.getImageDefinition(doc));
        group1.appendChild(this.getStartImageText(doc));
        group1.appendChild(this.getSubActivitiesSVGString(doc));
        group1.appendChild(this.getEndImageDefinition(doc));
        group1.appendChild(this.getArrows(doc));
        return group1;
    }

    protected Element getArrows(SVGDocument doc) {
        if (this.subActivities != null) {
            ActivityInterface prevActivity = null;
            Object prevElseActivity = null;
            ActivityInterface activity = null;
            String id = null;
            SVGCoordinates myStartCoords = this.getStartIconExitArrowCoords();
            SVGCoordinates myExitCoords = this.getEndIconEntryArrowCoords();
            SVGCoordinates myStartElseCoords = this.getStartIconElseArrowCoords();
            SVGCoordinates exitCoords = null;
            SVGCoordinates activityEntryCoords = null;
            SVGCoordinates activityExitCoords = null;
            Iterator itr = this.subActivities.iterator();
            Element subGroup = doc.createElementNS("http://www.w3.org/2000/svg", "g");
            while (itr.hasNext()) {
                activity = (ActivityInterface)itr.next();
                activityEntryCoords = activity.getEntryArrowCoords();
                activityExitCoords = activity.getExitArrowCoords();
                if (activity instanceof ElseIfImpl || activity instanceof ElseImpl) {
                    if (prevActivity != null && prevActivity instanceof ElseIfImpl) {
                        exitCoords = ((ElseIfInterface)prevActivity).getNextElseExitArrowCoords();
                        id = prevActivity.getId() + "-" + activity.getId();
                        subGroup.appendChild(this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, prevActivity, activity));
                        subGroup.appendChild(this.getArrowDefinition(doc, activityExitCoords.getXLeft(), activityExitCoords.getYTop(), myExitCoords.getXLeft(), myExitCoords.getYTop(), id, prevActivity, activity));
                    } else {
                        subGroup.appendChild(this.getArrowDefinition(doc, myStartElseCoords.getXLeft(), myStartElseCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, prevActivity, activity));
                        subGroup.appendChild(this.getArrowDefinition(doc, activityExitCoords.getXLeft(), activityExitCoords.getYTop(), myExitCoords.getXLeft(), myExitCoords.getYTop(), id, prevActivity, activity));
                    }
                } else if (prevActivity != null) {
                    exitCoords = prevActivity.getExitArrowCoords();
                    id = prevActivity.getId() + "-" + activity.getId();
                    subGroup.appendChild(this.getArrowDefinition(doc, exitCoords.getXLeft(), exitCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, prevActivity, activity));
                } else {
                    subGroup.appendChild(this.getArrowDefinition(doc, myStartCoords.getXLeft(), myStartCoords.getYTop(), activityEntryCoords.getXLeft(), activityEntryCoords.getYTop(), id, this, activity));
                    subGroup.appendChild(this.getArrowDefinition(doc, activityExitCoords.getXLeft(), activityExitCoords.getYTop(), myExitCoords.getXLeft(), myExitCoords.getYTop(), id, this, activity));
                }
                prevActivity = activity;
            }
            return subGroup;
        }
        return null;
    }

    @Override
    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    @Override
    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

