/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.EventHandlerInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ActivityImpl;

public class EventHandlerImpl
extends ActivityImpl
implements EventHandlerInterface {
    public EventHandlerImpl(String token) {
        super(token);
        if (this.name == null) {
            this.name = "EVENTHANDLER" + System.currentTimeMillis();
        }
        this.displayName = "Event Handlers";
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public EventHandlerImpl(OMElement omElement) {
        super(omElement);
        if (this.name == null) {
            this.name = "EVENTHANDLER" + System.currentTimeMillis();
        }
        this.displayName = "Event Handlers";
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public EventHandlerImpl(OMElement omElement, ActivityInterface parent) {
        super(omElement);
        this.setParent(parent);
        if (this.name == null) {
            this.name = "EVENTHANDLER" + System.currentTimeMillis();
        }
        this.displayName = "Event Handlers";
        this.startIconPath = BPEL2SVGFactory.getInstance().getIconPath(this.getClass().getName());
        this.endIconPath = BPEL2SVGFactory.getInstance().getEndIconPath(this.getClass().getName());
        this.setVerticalChildLayout(false);
    }

    public String getId() {
        return this.getName();
    }

    public String getEndTag() {
        return "/eventHandlers";
    }

    public SVGDimension getDimensions() {
        if (this.dimensions == null) {
            int width = 0;
            int height = 0;
            this.dimensions = new SVGDimension(width, height);
            SVGDimension subActivityDim = null;
            ActivityInterface activity2 = null;
            for (ActivityInterface activity2 : this.getSubActivities()) {
                subActivityDim = activity2.getDimensions();
                if (subActivityDim.getHeight() > height) {
                    height += subActivityDim.getHeight();
                }
                width += subActivityDim.getWidth();
            }
            this.dimensions.setWidth(width += this.getXSpacing());
            this.dimensions.setHeight(height += this.getYSpacing());
        }
        return this.dimensions;
    }

    public void layout(int startXLeft, int startYTop) {
        if (this.layoutManager.isVerticalLayout()) {
            this.layoutVertical(startXLeft, startYTop);
        } else {
            this.layoutHorizontal(startXLeft, startYTop);
        }
    }

    public void layoutVertical(int startXLeft, int startYTop) {
        int centreOfMyLayout = startXLeft + this.dimensions.getWidth() / 2;
        int xLeft = centreOfMyLayout - this.getStartIconWidth() / 2;
        int yTop = startYTop + this.getYSpacing() / 2;
        int endXLeft = centreOfMyLayout - this.getEndIconWidth() / 2;
        int endYTop = startYTop + this.dimensions.getHeight() - this.getEndIconHeight() - this.getYSpacing() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childYTop = startYTop + this.getYSpacing() / 2;
        int childXLeft = startXLeft + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childXLeft += activity.getDimensions().getWidth();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    private void layoutHorizontal(int startXLeft, int startYTop) {
        int centreOfMyLayout = startYTop + this.dimensions.getHeight() / 2;
        int xLeft = startXLeft + this.getYSpacing() / 2;
        int yTop = centreOfMyLayout - this.getStartIconHeight() / 2;
        int endXLeft = startXLeft + this.dimensions.getWidth() - this.getEndIconWidth() - this.getYSpacing() / 2;
        int endYTop = centreOfMyLayout - this.getEndIconHeight() / 2;
        ActivityInterface activity = null;
        Iterator<ActivityInterface> itr = this.getSubActivities().iterator();
        int childXLeft = startXLeft + this.getYSpacing() / 2;
        int childYTop = startYTop + this.getXSpacing() / 2;
        while (itr.hasNext()) {
            activity = itr.next();
            activity.layout(childXLeft, childYTop);
            childYTop += activity.getDimensions().getHeight();
        }
        this.setStartIconXLeft(xLeft);
        this.setStartIconYTop(yTop);
        this.setEndIconXLeft(endXLeft);
        this.setEndIconYTop(endYTop);
        this.setStartIconTextXLeft(startXLeft + 10);
        this.setStartIconTextYTop(startYTop + 10 + 10);
        this.getDimensions().setXLeft(startXLeft);
        this.getDimensions().setYTop(startYTop);
    }

    public SVGCoordinates getEntryArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getDimensions().getXLeft() + this.getDimensions().getWidth() / 2;
            yTop = this.getDimensions().getYTop() + 10;
        } else {
            xLeft = this.getDimensions().getXLeft() + 10;
            yTop = this.getDimensions().getYTop() + this.getDimensions().getHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public SVGCoordinates getExitArrowCoords() {
        int xLeft = 0;
        int yTop = 0;
        if (this.layoutManager.isVerticalLayout()) {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth() / 2;
            yTop = this.getEndIconYTop() + this.getEndIconHeight();
        } else {
            xLeft = this.getEndIconXLeft() + this.getEndIconWidth();
            yTop = this.getEndIconYTop() + this.getEndIconHeight() / 2;
        }
        SVGCoordinates coords = new SVGCoordinates(xLeft, yTop);
        return coords;
    }

    public Element getSVGString(SVGDocument doc) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.isAddOpacity()) {
            group.setAttributeNS(null, "style", "opacity:" + this.getOpacity());
        }
        group.appendChild(this.getBoxDefinition(doc));
        group.appendChild(this.getImageDefinition(doc));
        group.appendChild(this.getStartImageText(doc));
        group.appendChild(this.getSubActivitiesSVGString(doc));
        group.appendChild(this.getEndImageDefinition(doc));
        return group;
    }

    protected String getArrows() {
        StringBuffer svgSB = new StringBuffer();
        return svgSB.toString();
    }

    public boolean isAddOpacity() {
        return this.isAddCompositeActivityOpacity();
    }

    public double getOpacity() {
        return this.getCompositeOpacity();
    }
}

