/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bpel.ui.bpel2svg.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGDocument;
import org.wso2.carbon.bpel.ui.bpel2svg.ActivityInterface;
import org.wso2.carbon.bpel.ui.bpel2svg.BPEL2SVGFactory;
import org.wso2.carbon.bpel.ui.bpel2svg.BPELAttributeValuePair;
import org.wso2.carbon.bpel.ui.bpel2svg.LayoutManager;
import org.wso2.carbon.bpel.ui.bpel2svg.Link;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGCoordinates;
import org.wso2.carbon.bpel.ui.bpel2svg.SVGDimension;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.AssignImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CatchAllImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CatchImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CompensateImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CompensateScopeImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.CompensationHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ElseIfImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ElseImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.EventHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ExitImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.FaultHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.FlowImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ForEachImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.IfImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.InvokeImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.OnAlarmImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.OnEventImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.OnMessageImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.PickImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ProcessImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ReThrowImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ReceiveImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.RepeatUntilImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ReplyImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ScopeImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.SequenceImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.TerminationHandlerImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.ThrowImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.WaitImpl;
import org.wso2.carbon.bpel.ui.bpel2svg.impl.WhileImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ActivityImpl
implements ActivityInterface {
    protected LayoutManager layoutManager = BPEL2SVGFactory.getInstance().getLayoutManager();
    protected String name = null;
    protected String displayName = null;
    protected List<ActivityInterface> subActivities = new ArrayList<ActivityInterface>();
    protected List<BPELAttributeValuePair> attributes = new ArrayList<BPELAttributeValuePair>();
    protected int startLineNumber = -1;
    protected ActivityInterface.ActivityState state = ActivityInterface.ActivityState.Ready;
    public Map<String, Link> links;
    protected Set<ActivityInterface> sources;
    protected Set<ActivityInterface> targets;
    protected int correctionY = 0;
    protected ActivityInterface parent = null;
    protected String startIconPath = null;
    protected int startIconHeight = this.layoutManager.getStartIconDim();
    protected int startIconWidth = this.layoutManager.getStartIconDim();
    protected int startIconXLeft = 0;
    protected int startIconYTop = 0;
    protected int startIconTextXLeft = 0;
    protected int startIconTextYTop = 0;
    protected String endIconPath = null;
    protected int endIconHeight = this.layoutManager.getEndIconDim();
    protected int endIconWidth = this.layoutManager.getEndIconDim();
    protected int endIconXLeft = 0;
    protected int endIconYTop = 0;
    protected int endIconTextXLeft = 0;
    protected int endIconTextYTop = 0;
    protected boolean verticalChildLayout = true;
    protected SVGDimension dimensions = null;
    protected boolean exitIcon = false;
    protected SVGGraphics2D generator = null;
    protected DOMImplementation dom = SVGDOMImplementation.getDOMImplementation();
    protected String svgNS = "http://www.w3.org/2000/svg";
    protected SVGDocument doc = (SVGDocument)this.dom.createDocument(this.svgNS, "svg", null);
    protected Element root = this.doc.getDocumentElement();
    public static final int BOX_MARGIN = 10;
    protected int boxXLeft = 0;
    protected int boxYTop = 0;
    protected int boxHeight = 0;
    protected int boxWidth = 0;
    protected String boxStyle = "fill-opacity:0.04;fill-rule:evenodd;stroke:#0000FF;stroke-width:1.99999988;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;bbbbbbbstroke-opacity:1;fill:url(#orange_red);stroke-opacity:0.2";
    protected String failureBoxStyle = "fill-opacity:0.04;fill-rule:evenodd;stroke:#FF0000;stroke-width:2.99999988;stroke-linecap:square;stroke-linejoin:round;stroke-miterlimit:10;stroke-dasharray:none;bbbbbbbstroke-opacity:1;fill:url(#orange_red);stroke-opacity:0.8";
    private boolean largeArrow = false;

    @Override
    public List<BPELAttributeValuePair> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getCorrectionY() {
        return this.correctionY;
    }

    @Override
    public void setCorrectionY(int correctionY) {
        this.correctionY += correctionY;
    }

    @Override
    public ActivityInterface getParent() {
        return this.parent;
    }

    public void setParent(ActivityInterface parent) {
        this.parent = parent;
    }

    public ActivityImpl() {
    }

    public ActivityImpl(String token) {
        int lastQuoteIndex;
        int firstQuoteIndex;
        int nameIndex = token.indexOf("name");
        if (nameIndex >= 0 && (firstQuoteIndex = token.indexOf("\"", nameIndex + 1)) >= 0 && (lastQuoteIndex = token.indexOf("\"", firstQuoteIndex + 1)) > firstQuoteIndex) {
            this.setName(token.substring(firstQuoteIndex + 1, lastQuoteIndex));
            this.setDisplayName(this.getName());
        }
    }

    public ActivityImpl(OMElement omElement) {
        Iterator tmpIterator = omElement.getAllAttributes();
        while (tmpIterator.hasNext()) {
            OMAttribute omAttribute = (OMAttribute)tmpIterator.next();
            String tmpAttribute = new String(omAttribute.getLocalName());
            String tmpValue = new String(omAttribute.getAttributeValue());
            if (tmpAttribute == null || tmpValue == null) continue;
            this.attributes.add(new BPELAttributeValuePair(tmpAttribute, tmpValue));
            if (!tmpAttribute.equals(new String("name"))) continue;
            this.setName(tmpValue);
            this.setDisplayName(this.getName());
        }
        this.startLineNumber = omElement.getLineNumber();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    @Override
    public int getEndLineNumber() {
        int index;
        int ret = -1;
        ActivityInterface parent = this.getParent();
        if (parent != null && (index = parent.getSubActivities().indexOf(this)) != -1) {
            if (index < parent.getSubActivities().size() - 1) {
                ActivityInterface other = parent.getSubActivities().get(index + 1);
                ret = other.getStartLineNumber() - 1;
            } else {
                ret = parent.getEndLineNumber();
            }
        }
        return ret;
    }

    @Override
    public ActivityInterface getActivityAtLineNumber(int lineNumber) {
        ActivityInterface ret = null;
        int endline = this.getEndLineNumber();
        if (this.getStartLineNumber() <= lineNumber && (endline == -1 || endline >= lineNumber)) {
            Iterator<ActivityInterface> iter = this.subActivities.iterator();
            while (ret == null && iter.hasNext()) {
                ret = iter.next().getActivityAtLineNumber(lineNumber);
            }
            if (ret == null) {
                ret = this;
            }
        }
        return ret;
    }

    @Override
    public ActivityInterface.ActivityState getState() {
        return this.state;
    }

    @Override
    public void setState(ActivityInterface.ActivityState state) {
        this.state = state;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getLayerId() {
        return this.getLayerId(this.getId());
    }

    public String getLayerId(String id) {
        return id;
    }

    public boolean isAddOpacity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAddCompositeActivityOpacity() {
        return this.layoutManager.isAddCompositeActivityOpacity();
    }

    public boolean isAddIconOpacity() {
        return this.layoutManager.isAddIconOpacity();
    }

    public boolean isAddSimpleActivityOpacity() {
        return this.layoutManager.isAddSimpleActivityOpacity();
    }

    public double getOpacity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getSimpleActivityOpacity() {
        return this.layoutManager.getSimpleActivityOpacity(this.getState());
    }

    public double getCompositeOpacity() {
        return this.layoutManager.getCompositeActivityOpacity();
    }

    public double getIconOpacity(ActivityInterface.ActivityState state) {
        return this.layoutManager.getIconOpacity(state);
    }

    public String getBoxId() {
        return this.getId();
    }

    public String getStartImageId() {
        return this.getId();
    }

    public String getEndImageId() {
        return this.getId();
    }

    public String getArrowId(String startId, String endId) {
        return startId + "-" + endId + "-Arrow";
    }

    public String getStartImageTextId() {
        return this.getStartImageId();
    }

    public String getEndImageTextId() {
        return this.getEndImageId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getStartIconHeight() {
        return this.startIconHeight;
    }

    @Override
    public String getStartIconPath() {
        return this.startIconPath;
    }

    @Override
    public void setStartIconPath(String iconPath) {
        this.startIconPath = iconPath;
    }

    @Override
    public String getEndIconPath() {
        return this.endIconPath;
    }

    @Override
    public int getStartIconWidth() {
        return this.startIconWidth;
    }

    @Override
    public int getEndIconHeight() {
        return this.endIconHeight;
    }

    @Override
    public int getEndIconWidth() {
        return this.endIconWidth;
    }

    @Override
    public void setStartIconHeight(int iconHeight) {
        this.startIconHeight = iconHeight;
    }

    @Override
    public void setStartIconWidth(int iconWidth) {
        this.startIconWidth = iconWidth;
    }

    @Override
    public int getStartIconXLeft() {
        return this.startIconXLeft;
    }

    @Override
    public void setStartIconXLeft(int xLeft) {
        this.startIconXLeft = xLeft;
    }

    @Override
    public int getStartIconYTop() {
        return this.startIconYTop + this.correctionY;
    }

    @Override
    public void setStartIconYTop(int yTop) {
        this.startIconYTop = yTop;
    }

    public int getStartIconTextXLeft() {
        return this.startIconTextXLeft;
    }

    public void setStartIconTextXLeft(int startIconTextXLeft) {
        this.startIconTextXLeft = startIconTextXLeft;
    }

    public int getStartIconTextYTop() {
        return this.startIconTextYTop + this.correctionY;
    }

    public void setStartIconTextYTop(int startIconTextYTop) {
        this.startIconTextYTop = startIconTextYTop;
    }

    @Override
    public int getEndIconXLeft() {
        return this.endIconXLeft;
    }

    @Override
    public void setEndIconXLeft(int xLeftEnd) {
        this.endIconXLeft = xLeftEnd;
    }

    @Override
    public int getEndIconYTop() {
        return this.endIconYTop + this.correctionY;
    }

    @Override
    public void setEndIconYTop(int yTopEnd) {
        this.endIconYTop = yTopEnd;
    }

    public int getEndIconTextXLeft() {
        return this.endIconTextXLeft;
    }

    public void setEndIconTextXLeft(int endIconTextXLeft) {
        this.endIconTextXLeft = endIconTextXLeft;
    }

    public int getEndIconTextYTop() {
        return this.endIconTextYTop;
    }

    public void setEndIconTextYTop(int endIconTextYTop) {
        this.endIconTextYTop = endIconTextYTop;
    }

    public int getXSpacing() {
        return this.layoutManager.getXSpacing();
    }

    public int getYSpacing() {
        return this.layoutManager.getYSpacing();
    }

    public int getBoxHeight() {
        return this.boxHeight;
    }

    public void setBoxHeight(int boxHeight) {
        this.boxHeight = boxHeight;
    }

    public String getBoxStyle() {
        if (this.getState() == ActivityInterface.ActivityState.Failed) {
            return this.failureBoxStyle;
        }
        return this.boxStyle;
    }

    public void setBoxStyle(String boxStyle) {
        this.boxStyle = boxStyle;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    public int getBoxXLeft() {
        return this.boxXLeft;
    }

    public void setBoxXLeft(int boxXLeft) {
        this.boxXLeft = boxXLeft;
    }

    public int getBoxYTop() {
        return this.boxYTop;
    }

    public void setBoxYTop(int boxYTop) {
        this.boxYTop = boxYTop;
    }

    public boolean isExitIcon() {
        return this.exitIcon;
    }

    public void setExitIcon(boolean exitIcon) {
        this.exitIcon = exitIcon;
    }

    public void setEndIconHeight(int iconHeightEnd) {
        this.endIconHeight = iconHeightEnd;
    }

    public void setEndIconWidth(int iconWidthEnd) {
        this.endIconWidth = iconWidthEnd;
    }

    @Override
    public boolean isIncludeAssigns() {
        return this.layoutManager.isIncludeAssigns();
    }

    @Override
    public List<ActivityInterface> getSubActivities() {
        return this.subActivities;
    }

    @Override
    public boolean isVerticalChildLayout() {
        return this.verticalChildLayout;
    }

    @Override
    public void setVerticalChildLayout(boolean verticalChildLayout) {
        this.verticalChildLayout = verticalChildLayout;
    }

    @Override
    public boolean isHorizontalChildLayout() {
        return !this.isVerticalChildLayout();
    }

    @Override
    public Element getSVGString(SVGDocument doc) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Element getSubActivitiesSVGString(SVGDocument doc) {
        Iterator<ActivityInterface> itr = this.subActivities.iterator();
        ActivityInterface activity = null;
        Element subElement = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        while (itr.hasNext()) {
            activity = itr.next();
            subElement.appendChild(activity.getSVGString(doc));
            this.name = activity.getId();
        }
        return subElement;
    }

    protected Element getImageDefinition(SVGDocument doc, String imgPath, int imgXLeft, int imgYTop, int imgWidth, int imgHeight, String id) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", this.getLayerId());
        if (this.getStartIconPath() != null) {
            group.setAttributeNS(null, "style", "opacity:" + this.getIconOpacity(this.getState()));
            Element image = doc.createElementNS("http://www.w3.org/2000/svg", "image");
            image.setAttributeNS(null, "xlink:href", imgPath);
            image.setAttributeNS(null, "x", String.valueOf(imgXLeft));
            image.setAttributeNS(null, "y", String.valueOf(imgYTop));
            image.setAttributeNS(null, "width", String.valueOf(imgWidth));
            image.setAttributeNS(null, "height", String.valueOf(imgHeight));
            image.setAttributeNS(null, "id", id);
            image.setAttributeNS("xlink", "title", this.getActivityInfoString());
            group.appendChild(image);
            return group;
        }
        return group;
    }

    protected Element getImageDefinition(SVGDocument doc) {
        return this.getImageDefinition(doc, this.getStartIconPath(), this.getStartIconXLeft(), this.getStartIconYTop(), this.getStartIconWidth(), this.getStartIconHeight(), this.getStartImageId());
    }

    protected Element getEndImageDefinition(SVGDocument doc) {
        return this.getImageDefinition(doc, this.getEndIconPath(), this.getEndIconXLeft(), this.getEndIconYTop(), this.getEndIconWidth(), this.getEndIconHeight(), this.getEndImageId());
    }

    protected Element getImageText(SVGDocument doc, int imgXLeft, int imgYTop, int imgWidth, int imgHeight, String imgName, String imgDisplayName) {
        int txtXLeft = imgXLeft;
        int txtYTop = imgYTop;
        Element a = doc.createElementNS("http://www.w3.org/2000/svg", "a");
        if (imgDisplayName != null) {
            a.setAttributeNS(null, "id", imgName);
            Element text1 = doc.createElementNS("http://www.w3.org/2000/svg", "text");
            text1.setAttributeNS(null, "x", String.valueOf(txtXLeft));
            text1.setAttributeNS(null, "y", String.valueOf(txtYTop));
            text1.setAttributeNS(null, "id", imgName + ".Text");
            text1.setAttributeNS(null, "xml:space", "preserve");
            text1.setAttributeNS(null, "style", "font-size:12px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:start;line-height:125%;writing-mode:lr-tb;text-anchor:start;fill:#000000;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:Arial Narrow;-inkscape-font-specification:Arial Narrow");
            Element tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
            tspan.setAttributeNS(null, "x", String.valueOf(txtXLeft));
            tspan.setAttributeNS(null, "y", String.valueOf(txtYTop));
            tspan.setAttributeNS(null, "id", "tspan-" + imgName);
            Text text2 = doc.createTextNode(imgDisplayName);
            tspan.appendChild(text2);
            text1.appendChild(tspan);
            a.appendChild(text1);
        }
        return a;
    }

    protected Element getStartImageText(SVGDocument doc) {
        return this.getImageText(doc, this.getStartIconTextXLeft(), this.getStartIconTextYTop(), this.getStartIconWidth(), this.getStartIconHeight(), this.getStartImageTextId(), this.getDisplayName());
    }

    protected void getEndImageText(SVGDocument doc) {
        this.getImageText(doc, this.getEndIconTextXLeft(), this.getEndIconTextYTop(), this.getStartIconWidth(), this.getStartIconHeight(), this.getEndImageTextId(), this.getDisplayName());
    }

    protected boolean isLargeArrow() {
        return this.largeArrow;
    }

    protected void setLargeArrow(boolean largeArrow) {
        this.largeArrow = largeArrow;
    }

    private String getArrowStyle(ActivityInterface start, ActivityInterface end) {
        String op = "1";
        if (start != null && start.getState() == ActivityInterface.ActivityState.Ready || end != null && end.getState() == ActivityInterface.ActivityState.Ready) {
            op = "0.3";
        }
        String largeArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#Arrow1Lend);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:" + op;
        String mediumArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#Arrow1Mend);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:" + op;
        if (this.largeArrow) {
            return largeArrowStr;
        }
        return mediumArrowStr;
    }

    protected String getLinkArrowStyle() {
        String largeArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#LinkArrow);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1;opacity: 0.25;";
        String mediumArrowStr = "fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1.0;stroke-linecap:butt;stroke-linejoin:round;marker-end:url(#LinkArrow);stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1;opacity: 0.25;";
        if (this.largeArrow) {
            return largeArrowStr;
        }
        return mediumArrowStr;
    }

    protected Element getArrowDefinition(SVGDocument doc, int startX, int startY, int endX, int endY, String id, ActivityInterface start, ActivityInterface end) {
        Element path = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        if (startX == endX || startY == endY) {
            path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + endX + "," + endY);
        } else if (this.layoutManager.isVerticalLayout()) {
            path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + startX + "," + (startY + 2 * endY) / 3 + " L " + endX + "," + (startY + 2 * endY) / 3 + " L " + endX + "," + endY);
        } else {
            path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + startY + " L " + (startX + 1 * endX) / 2 + "," + endY + " L " + endX + "," + endY);
        }
        path.setAttributeNS(null, "id", id);
        path.setAttributeNS(null, "style", this.getArrowStyle(start, end));
        return path;
    }

    protected Element getArrowDefinition(SVGDocument doc, int startX, int startY, int midX, int midY, int endX, int endY, String id, ActivityInterface start, ActivityInterface end) {
        Element path = doc.createElementNS("http://www.w3.org/2000/svg", "path");
        path.setAttributeNS(null, "d", "M " + startX + "," + startY + " L " + midX + "," + midY + "L " + endX + "," + endY);
        path.setAttributeNS(null, "id", id);
        path.setAttributeNS(null, "style", this.getArrowStyle(start, end));
        return path;
    }

    protected Element getBoxDefinition(SVGDocument doc) {
        return this.getBoxDefinition(doc, this.getDimensions().getXLeft() + 10, this.getDimensions().getYTop() + 10, this.getDimensions().getWidth() - 20, this.getDimensions().getHeight() - 20, this.getBoxId());
    }

    protected Element getBoxDefinition(SVGDocument doc, int boxXLeft, int boxYTop, int boxWidth, int boxHeight, String id) {
        Element group = null;
        group = doc.createElementNS("http://www.w3.org/2000/svg", "g");
        group.setAttributeNS(null, "id", "Layer-" + id);
        if (this.layoutManager.isShowSequenceBoxes()) {
            Element rect = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
            rect.setAttributeNS(null, "width", String.valueOf(boxWidth));
            rect.setAttributeNS(null, "height", String.valueOf(boxHeight));
            rect.setAttributeNS(null, "x", String.valueOf(boxXLeft));
            rect.setAttributeNS(null, "y", String.valueOf(boxYTop));
            rect.setAttributeNS(null, "id", "Rect" + id);
            rect.setAttributeNS(null, "rx", "10");
            rect.setAttributeNS(null, "ry", "10");
            rect.setAttributeNS(null, "style", this.getBoxStyle());
            group.appendChild(rect);
        }
        return group;
    }

    @Override
    public SVGDimension getDimensions() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void switchDimensionsToHorizontal() {
        int width = 0;
        int height = 0;
        ActivityInterface activity2 = null;
        for (ActivityInterface activity2 : this.getSubActivities()) {
            activity2.switchDimensionsToHorizontal();
        }
        width = this.getDimensions().getWidth();
        height = this.getDimensions().getHeight();
        this.getDimensions().setHeight(width);
        this.getDimensions().setWidth(height);
    }

    @Override
    public void layout(int startXLeft, int startYTop) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getEndTag() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public SVGCoordinates getEntryArrowCoords() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SVGCoordinates getExitArrowCoords() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void passContent() {
        this.root = this.doc.getDocumentElement();
        this.generator.getRoot(this.root);
    }

    @Override
    public Set<ActivityInterface> getLinkRoots() {
        this.sources.removeAll(this.targets);
        return this.sources;
    }

    @Override
    public ActivityInterface processSubActivities(OMElement omElement) {
        ActivityInterface endActivity = null;
        if (omElement != null) {
            ActivityImpl activity = null;
            Iterator iterator = omElement.getChildElements();
            while (iterator.hasNext()) {
                ActivityInterface replyActivity;
                OMElement tmpElement = (OMElement)iterator.next();
                if (tmpElement.getLocalName().equals("assign") && this.isIncludeAssigns()) {
                    activity = new AssignImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("catchAll")) {
                    activity = new CatchAllImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("catch")) {
                    activity = new CatchImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("compensateScope")) {
                    activity = new CompensateScopeImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("compensate")) {
                    activity = new CompensateImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("compensationHandler")) {
                    activity = new CompensationHandlerImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("elseif")) {
                    activity = new ElseIfImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("else")) {
                    activity = new ElseImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("eventHandlers")) {
                    activity = new EventHandlerImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("exit")) {
                    activity = new ExitImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("faultHandlers")) {
                    activity = new FaultHandlerImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("flow")) {
                    activity = new FlowImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("forEach")) {
                    activity = new ForEachImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("if")) {
                    activity = new IfImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("invoke")) {
                    activity = new InvokeImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("onAlarm")) {
                    activity = new OnAlarmImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("onEvent")) {
                    activity = new OnEventImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("onMessage")) {
                    activity = new OnMessageImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("pick")) {
                    activity = new PickImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("process")) {
                    activity = new ProcessImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("receive")) {
                    activity = new ReceiveImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("repeatUntil")) {
                    activity = new RepeatUntilImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("reply")) {
                    activity = new ReplyImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("rethrow")) {
                    activity = new ReThrowImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("scope")) {
                    activity = new ScopeImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("sequence")) {
                    activity = new SequenceImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("terminationHandler")) {
                    activity = new TerminationHandlerImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("throw")) {
                    activity = new ThrowImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("wait")) {
                    activity = new WaitImpl(tmpElement, this);
                } else if (tmpElement.getLocalName().equals("while")) {
                    activity = new WhileImpl(tmpElement, this);
                } else {
                    if (!tmpElement.getLocalName().equals(this.getEndTag())) continue;
                    break;
                }
                activity.setLinkProperties(this.links, this.sources, this.targets);
                this.subActivities.add(activity);
                if (tmpElement.getChildElements().hasNext() && (replyActivity = activity.processSubActivities(tmpElement)) != null) {
                    this.subActivities.add(replyActivity);
                }
                if (!tmpElement.getLocalName().equals("process")) continue;
                break;
            }
        }
        return endActivity;
    }

    @Override
    public Element getRoot() {
        return this.root;
    }

    @Override
    public String getActivityInfoString() {
        String infoString = null;
        for (BPELAttributeValuePair x : this.attributes) {
            String attrib = x.getAttribute();
            String val = x.getValue();
            if (infoString == null) {
                infoString = "<" + attrib + "=" + val + "> ";
                continue;
            }
            infoString = infoString + "<" + attrib + "=" + val + "> ";
        }
        if (infoString != null) {
            return infoString;
        }
        return "No Attributes defined";
    }

    @Override
    public Map<String, Link> getLinks() {
        return this.links;
    }

    @Override
    public void setLinkProperties(Map<String, Link> links, Set<ActivityInterface> sources, Set<ActivityInterface> targets) {
        this.links = links;
        this.sources = sources;
        this.targets = targets;
    }
}

