/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.util.Set;
import javax.lang.model.element.Modifier;
import org.revapi.Element;
import org.revapi.Reference;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.JavaModelElement;

public final class UseSite
extends Reference<JavaElement> {
    public UseSite(Type useType, JavaElement site) {
        super((Element)site, (Reference.Type)useType);
    }

    public Type getType() {
        return (Type)super.getType();
    }

    public boolean isMovingToApi() {
        if (!this.getType().isMovingToApi()) {
            return false;
        }
        return UseSite.isEffectivelyInApi((JavaElement)this.getElement());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UseSite[");
        sb.append("site=").append(this.getElement());
        sb.append(", useType=").append((Object)this.getType());
        sb.append(']');
        return sb.toString();
    }

    private static boolean isEffectivelyInApi(JavaElement el) {
        if (!(el instanceof JavaModelElement)) {
            return true;
        }
        JavaModelElement me = (JavaModelElement)el;
        JavaModelElement parent = me.getParent();
        if (me instanceof JavaMethodParameterElement) {
            return UseSite.isEffectivelyInApi(parent);
        }
        Set<Modifier> modifiers = me.getDeclaringElement().getModifiers();
        if (modifiers.contains((Object)Modifier.PUBLIC)) {
            return parent == null || UseSite.isEffectivelyInApi(parent);
        }
        if (modifiers.contains((Object)Modifier.PROTECTED)) {
            if (parent != null && parent.getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL)) {
                return false;
            }
            return parent == null || UseSite.isEffectivelyInApi(parent);
        }
        return false;
    }

    public static enum Type implements Reference.Type<JavaElement>
    {
        ANNOTATES,
        IS_INHERITED,
        IS_IMPLEMENTED,
        HAS_TYPE,
        RETURN_TYPE,
        PARAMETER_TYPE,
        IS_THROWN,
        CONTAINS,
        TYPE_PARAMETER_OR_BOUND;


        public boolean isMovingToApi() {
            switch (this) {
                case ANNOTATES: 
                case CONTAINS: 
                case IS_INHERITED: 
                case IS_IMPLEMENTED: {
                    return false;
                }
            }
            return true;
        }

        public String getName() {
            return this.name();
        }
    }
}

