/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import java.util.Collection;
import org.restlet.data.Header;
import org.restlet.data.Protocol;
import org.restlet.data.RecipientInfo;
import org.restlet.engine.header.HeaderReader;

public class RecipientInfoReader
extends HeaderReader<RecipientInfo> {
    public static void addValues(Header header, Collection<RecipientInfo> collection) {
        new RecipientInfoReader(header.getValue()).addValues(collection);
    }

    public RecipientInfoReader(String header) {
        super(header);
    }

    @Override
    public RecipientInfo readValue() throws IOException {
        RecipientInfo result = new RecipientInfo();
        String protocolToken = this.readToken();
        if (protocolToken == null || protocolToken.isEmpty()) {
            throw new IOException("Unexpected empty protocol token for while reading recipient info header, please check the value.");
        }
        if (this.peek() == 47) {
            this.read();
            result.setProtocol(new Protocol(protocolToken, protocolToken, null, -1, this.readToken()));
        } else {
            result.setProtocol(new Protocol("HTTP", "HTTP", null, -1, protocolToken));
        }
        if (this.skipSpaces()) {
            result.setName(this.readRawText());
            if (this.skipSpaces()) {
                result.setComment(this.readComment());
            }
        }
        return result;
    }
}

