/*
 * Decompiled with CFR 0.152.
 */
package org.reactivestreams.tck.flow.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.Executor;
import org.reactivestreams.example.unicast.AsyncIterablePublisher;
import org.reactivestreams.tck.flow.support.Function;

public class HelperPublisher<T>
extends AsyncIterablePublisher<T> {
    public HelperPublisher(final int from, final int to, final Function<Integer, T> create, Executor executor) {
        super(new Iterable<T>(){
            {
                if (from > to) {
                    throw new IllegalArgumentException("from must be equal or greater than to!");
                }
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    private int at;
                    {
                        this.at = from;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.at < to;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            return Collections.emptyList().iterator().next();
                        }
                        try {
                            return create.apply(this.at++);
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException(String.format("Failed to create element for id %d!", this.at - 1), t);
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, executor);
    }
}

