/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.model.ClassNodeModelFactory;
import org.raml.yagi.framework.model.DefaultNodeBaseModel;
import org.raml.yagi.framework.model.ModelBinding;
import org.raml.yagi.framework.model.ModelBindingConfiguration;
import org.raml.yagi.framework.model.ModelReverseBinding;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.model.PackageModelBinding;
import org.raml.yagi.framework.model.PackageReverseBinding;
import org.raml.yagi.framework.model.SimpleBinding;
import org.raml.yagi.framework.model.SimpleClassNameBinding;

public class DefaultModelBindingConfiguration
implements ModelBindingConfiguration {
    private List<ModelBinding> bindings = new ArrayList<ModelBinding>();
    private List<ModelReverseBinding> reverseBinding = new ArrayList<ModelReverseBinding>();
    private NodeModelFactory defaultBinding = new ClassNodeModelFactory(DefaultNodeBaseModel.class);

    @Override
    @Nonnull
    public NodeModelFactory bindingOf(Class<?> className) {
        for (ModelBinding binding : this.bindings) {
            NodeModelFactory result = binding.binding(className);
            if (result == null) continue;
            return result;
        }
        if (this.defaultBinding != null) {
            return this.defaultBinding;
        }
        throw new RuntimeException("No binding found for " + className);
    }

    @Override
    @Nonnull
    public Class<?> reverseBindingOf(NodeModel model) {
        for (ModelReverseBinding modelReverseBinding : this.reverseBinding) {
            Class<?> aClass = modelReverseBinding.reverseBindingOf(model);
            if (aClass == null) continue;
            return aClass;
        }
        throw new RuntimeException("No reverse bind found for " + model.getClass());
    }

    public DefaultModelBindingConfiguration bindPackage(String basePackageName) {
        this.bindings.add(new PackageModelBinding(basePackageName));
        return this;
    }

    public DefaultModelBindingConfiguration bindSimpleName(Class<? extends NodeModel> modelClass, String ... names) {
        this.bindings.add(new SimpleClassNameBinding(new HashSet<String>(Arrays.asList(names)), modelClass));
        return this;
    }

    public DefaultModelBindingConfiguration bind(Class<?> anInterface, Class<? extends NodeModel> model) {
        this.bindings.add(new SimpleBinding(anInterface, new ClassNodeModelFactory(model)));
        return this;
    }

    public DefaultModelBindingConfiguration bind(Class<?> clazz, NodeModelFactory factory) {
        this.bindings.add(new SimpleBinding(clazz, factory));
        return this;
    }

    public DefaultModelBindingConfiguration defaultTo(Class<? extends NodeModel> defaultClass) {
        this.defaultBinding = new ClassNodeModelFactory(defaultClass);
        return this;
    }

    public DefaultModelBindingConfiguration reverseBindPackage(String basePackage) {
        this.reverseBinding.add(new PackageReverseBinding(basePackage));
        return this;
    }
}

