/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class MaxItemsRule
extends Rule {
    private int maxItems;

    public MaxItemsRule(int maxItems) {
        this.maxItems = maxItems;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node.getChildren().size() <= this.maxItems;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, new Object[0]);
        }
        return ErrorNodeFactory.createInvalidMaxItems(this.maxItems);
    }

    @Override
    public String getDescription() {
        return "Max amount of items " + this.maxItems;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }
}

