/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;

public class ClassPathResourceLoader
implements ResourceLoaderExtended {
    private final String rootRamlPackage;
    private URI callbackParam;

    public ClassPathResourceLoader() {
        this.rootRamlPackage = "";
    }

    public ClassPathResourceLoader(String rootRamlPackage) {
        this.rootRamlPackage = StringUtils.isBlank((String)rootRamlPackage) || rootRamlPackage.equals("/") ? "" : (rootRamlPackage.startsWith("/") ? rootRamlPackage.substring(1) : rootRamlPackage) + "/";
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        resourceName = this.rootRamlPackage + (resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        }
        if (callback != null && inputStream != null) {
            try {
                this.callbackParam = Thread.currentThread().getContextClassLoader().getResource(resourceName).toURI();
                callback.onResourceFound(this.callbackParam);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return inputStream;
    }

    @Override
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam() {
        return this.callbackParam;
    }
}

