/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonUtils {
    private static final String JSON_STRICT_DUPLICATE_DETECTION_PROPERTY = "yagi.json_duplicate_keys_detection";
    private static final boolean STRICT_DUPLICATE_DETECTION_VALUE = Boolean.valueOf(System.getProperty("yagi.json_duplicate_keys_detection", "true"));

    public static JsonNode parseJson(String value) throws IOException {
        return JsonUtils.parseJson(new StringReader(value));
    }

    public static JsonNode parseJson(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, STRICT_DUPLICATE_DETECTION_VALUE);
        return (JsonNode)mapper.readValue(reader, JsonNode.class);
    }
}

