/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.nodes.ExternalSchemaTypeExpressionNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.nodes.NamedTypeExpressionNode;
import org.raml.v2.internal.utils.xml.XsdResourceResolver;
import org.xml.sax.SAXException;

public class SchemaGenerator {
    public static Schema generateXmlSchema(ResourceLoader resourceLoader, XmlSchemaExternalType xmlTypeDefinition) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        factory.setResourceResolver(new XsdResourceResolver(resourceLoader, xmlTypeDefinition.getSchemaPath()));
        String includedResourceUri = SchemaGenerator.resolveResourceUriIfIncluded(xmlTypeDefinition);
        return factory.newSchema(new StreamSource(new StringReader(xmlTypeDefinition.getSchemaValue()), includedResourceUri));
    }

    public static JsonSchema generateJsonSchema(JsonSchemaExternalType jsonTypeDefinition) throws IOException, ProcessingException {
        String includedResourceUri = SchemaGenerator.resolveResourceUriIfIncluded(jsonTypeDefinition);
        JsonNode jsonSchema = JsonLoader.fromString((String)jsonTypeDefinition.getSchemaValue());
        JsonSchemaFactory factory = JsonSchemaFactory.newBuilder().freeze();
        if (jsonTypeDefinition.getInternalFragment() != null) {
            return factory.getJsonSchema(jsonSchema, "/definitions/" + jsonTypeDefinition.getInternalFragment());
        }
        if (includedResourceUri != null) {
            return factory.getJsonSchema(includedResourceUri);
        }
        return factory.getJsonSchema(jsonSchema);
    }

    @Nullable
    private static String resolveResourceUriIfIncluded(ResolvedType typeDefinition) {
        TypeExpressionNode typeDeclarationNode = typeDefinition.getTypeExpressionNode();
        if (typeDeclarationNode instanceof ExternalSchemaTypeExpressionNode) {
            ExternalSchemaTypeExpressionNode schema = (ExternalSchemaTypeExpressionNode)typeDeclarationNode;
            return schema.getStartPosition().getIncludedResourceUri();
        }
        List schemas = typeDeclarationNode.findDescendantsWith(ExternalSchemaTypeExpressionNode.class);
        if (schemas.size() > 0) {
            return ((ExternalSchemaTypeExpressionNode)schemas.get(0)).getStartPosition().getIncludedResourceUri();
        }
        List refNode = typeDeclarationNode.findDescendantsWith(NamedTypeExpressionNode.class);
        if (refNode.size() > 0 && (typeDeclarationNode = ((NamedTypeExpressionNode)refNode.get(0)).resolveReference()) != null && (schemas = typeDeclarationNode.findDescendantsWith(ExternalSchemaTypeExpressionNode.class)).size() > 0) {
            return ((ExternalSchemaTypeExpressionNode)schemas.get(0)).getStartPosition().getIncludedResourceUri();
        }
        return null;
    }

    public static boolean isJsonSchema(String schema) {
        return schema.trim().startsWith("{");
    }

    public static boolean isXmlSchema(String schema) {
        return schema.trim().startsWith("<");
    }
}

