/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.nodes.ArrayTypeExpressionNode;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.yagi.framework.nodes.AbstractRamlNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.SimpleTypeNode;

public class UnionTypeExpressionNode
extends AbstractRamlNode
implements TypeExpressionNode,
SimpleTypeNode<String> {
    public UnionTypeExpressionNode() {
    }

    private UnionTypeExpressionNode(UnionTypeExpressionNode unionTypeTypeNode) {
        super((AbstractRamlNode)unionTypeTypeNode);
    }

    @Nonnull
    public Position getStartPosition() {
        return ((Node)this.getChildren().get(0)).getStartPosition();
    }

    @Nonnull
    public Position getEndPosition() {
        return ((Node)this.getChildren().get(this.getChildren().size() - 1)).getEndPosition();
    }

    @Nonnull
    public Node copy() {
        return new UnionTypeExpressionNode(this);
    }

    public List<TypeExpressionNode> of() {
        ArrayList<TypeExpressionNode> of = new ArrayList<TypeExpressionNode>();
        for (Node node : this.getChildren()) {
            if (!(node instanceof TypeExpressionNode)) continue;
            of.add((TypeExpressionNode)node);
        }
        return of;
    }

    public NodeType getType() {
        return NodeType.String;
    }

    @Override
    @Nullable
    public ResolvedType generateDefinition() {
        List<TypeExpressionNode> of = this.of();
        ArrayList<ResolvedType> definitions = new ArrayList<ResolvedType>();
        ResolvedCustomFacets customFacets = new ResolvedCustomFacets(new String[0]);
        for (TypeExpressionNode typeExpressionNode : of) {
            ResolvedType resolvedType = typeExpressionNode.generateDefinition();
            if (resolvedType == null) continue;
            definitions.add(resolvedType);
            customFacets = customFacets.mergeWith(resolvedType.customFacets());
        }
        return new UnionResolvedType(this, definitions, customFacets);
    }

    @Override
    public String getTypeExpressionText() {
        return this.getValue();
    }

    public String getValue() {
        String unionOperator = " | ";
        StringBuilder result = new StringBuilder();
        for (TypeExpressionNode typeExpressionNode : this.of()) {
            String typeExpression = typeExpressionNode.getTypeExpressionText();
            if (typeExpression != null) {
                result.append(ArrayTypeExpressionNode.addParenthesesIfNeeded(typeExpression)).append(unionOperator);
                continue;
            }
            return null;
        }
        return result.delete(result.length() - unionOperator.length(), result.length()).toString();
    }

    public String getLiteralValue() {
        return this.getValue();
    }
}

