/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.nodes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.api.model.v10.declarations.AnnotationTarget;
import org.raml.v2.internal.impl.commons.nodes.AnnotationReferenceNode;
import org.raml.v2.internal.impl.commons.nodes.AnnotationTypeNode;
import org.raml.v2.internal.impl.commons.nodes.BodyNode;
import org.raml.v2.internal.impl.commons.nodes.DocumentationItemNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.OverlayableNode;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.ResponseNode;
import org.raml.v2.internal.impl.commons.nodes.SecuritySchemeNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.StringNode;

public class AnnotationNode
extends KeyValueNodeImpl
implements OverlayableNode {
    public AnnotationNode() {
    }

    public AnnotationNode(AnnotationNode node) {
        super((KeyValueNodeImpl)node);
    }

    public String getName() {
        return this.getKey().getRefName();
    }

    @Nullable
    public AnnotationTypeNode getAnnotationTypeNode() {
        AnnotationReferenceNode key = this.getKey();
        return (AnnotationTypeNode)key.getRefNode();
    }

    @Nonnull
    public Node copy() {
        return new AnnotationNode(this);
    }

    public AnnotationReferenceNode getKey() {
        AnnotationReferenceNode node = null;
        if (super.getKey() instanceof AnnotationReferenceNode) {
            node = (AnnotationReferenceNode)super.getKey();
        }
        return node;
    }

    public AnnotationTarget getTarget() {
        Node grampa;
        Node parent = this.getParent();
        Node node = grampa = parent != null ? parent.getParent() : null;
        if (parent instanceof RamlDocumentNode) {
            return AnnotationTarget.API;
        }
        if (parent instanceof DocumentationItemNode) {
            return AnnotationTarget.DocumentationItem;
        }
        if (grampa instanceof ResourceNode) {
            return AnnotationTarget.Resource;
        }
        if (grampa instanceof MethodNode) {
            return AnnotationTarget.Method;
        }
        if (grampa instanceof BodyNode) {
            if (grampa.findAncestorWith(ResponseNode.class) != null) {
                return AnnotationTarget.ResponseBody;
            }
            return AnnotationTarget.RequestBody;
        }
        if (parent instanceof TypeDeclarationNode) {
            return AnnotationTarget.TypeDeclaration;
        }
        if (grampa instanceof ResponseNode) {
            return AnnotationTarget.Response;
        }
        if (grampa instanceof SecuritySchemeNode) {
            return AnnotationTarget.SecurityScheme;
        }
        if (this.isSecuritySchemeSettings(grampa)) {
            return AnnotationTarget.SecuritySchemeSettings;
        }
        return null;
    }

    private boolean isSecuritySchemeSettings(Node grampa) {
        Node key;
        boolean result = false;
        if (grampa instanceof KeyValueNode && (key = ((KeyValueNode)grampa).getKey()) instanceof StringNode && "settings".equals(((StringNode)key).getValue())) {
            result = grampa.findAncestorWith(SecuritySchemeNode.class) != null;
        }
        return result;
    }
}

