/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.rss;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.AllocationUnit;
import org.quickperf.jvm.allocation.ByteAllocationMeasureFormatter;
import org.quickperf.jvm.annotations.ExpectMaxRSS;
import org.quickperf.jvm.rss.ProcessStatus;
import org.quickperf.measure.PerfMeasure;

public class ExpectMaxRssPerfVerifier
implements VerifiablePerformanceIssue<ExpectMaxRSS, ProcessStatus> {
    public static final VerifiablePerformanceIssue INSTANCE = new ExpectMaxRssPerfVerifier();
    private final ByteAllocationMeasureFormatter byteAllocationMeasureFormatter = ByteAllocationMeasureFormatter.INSTANCE;

    private ExpectMaxRssPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxRSS annotation, ProcessStatus processStatus) {
        Allocation measuredRss;
        Allocation maxExpectedRss = new Allocation(Double.valueOf(annotation.value()), annotation.unit());
        if (maxExpectedRss.isLessThan((PerfMeasure)(measuredRss = new Allocation(Double.valueOf(processStatus.getRssInKb()), AllocationUnit.KILO_BYTE)))) {
            String assertionMessage = "Expected RSS to be less than " + this.byteAllocationMeasureFormatter.format(maxExpectedRss) + " but is " + this.byteAllocationMeasureFormatter.formatAndAppendAllocationInBytes(measuredRss) + ".";
            String description = assertionMessage + System.lineSeparator() + measuredRss.getComment();
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }
}

