/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.heap;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;

public class HeapDumper {
    private HeapDumper() {
    }

    public static void dumpHeap(String fileName) {
        HeapDumper.dumpHeap(false, fileName);
    }

    public static void dumpHeapWithOnlyLiveObjects(String fileName) {
        HeapDumper.dumpHeap(true, fileName);
    }

    private static void dumpHeap(boolean live, String heapDumpFilePath) {
        HotSpotDiagnosticMXBean hotSpotDiagnosticMXBean;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            hotSpotDiagnosticMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServer, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            hotSpotDiagnosticMXBean.dumpHeap(heapDumpFilePath, live);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        System.out.println();
        String pointingRight = "\ud83d\udc49";
        System.out.println("[QUICK PERF] Heap dump file " + (live ? "(live=true) " : "") + System.lineSeparator() + pointingRight + " " + heapDumpFilePath);
    }
}

