/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.gc;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.JVM;
import org.quickperf.jvm.annotations.EnableGcLogging;
import org.quickperf.testlauncher.AnnotationToJvmOptionConverter;
import org.quickperf.testlauncher.JvmOption;

public class EnableGcLoggingAnnotToJvmOptionConverter
implements AnnotationToJvmOptionConverter<EnableGcLogging> {
    public static final EnableGcLoggingAnnotToJvmOptionConverter INSTANCE = new EnableGcLoggingAnnotToJvmOptionConverter();

    private EnableGcLoggingAnnotToJvmOptionConverter() {
    }

    public List<JvmOption> convertToJvmOptions(EnableGcLogging annotation, WorkingFolder workingFolder) {
        String gcLogPath = workingFolder.getPath() + File.separator + "gc.log";
        System.out.println("GC log file: " + gcLogPath);
        JVM.Version jvmVersion = JVM.INSTANCE.version;
        if (jvmVersion.isGreaterThanOrEqualTo9()) {
            return Arrays.asList(new JvmOption("-Xlog:gc*,gc+age=trace:file=\\\"" + gcLogPath + "\\\":tags,uptime,time"));
        }
        return Arrays.asList(new JvmOption("-XX:+PrintGCDetails"), new JvmOption("-XX:+PrintGCTimeStamps"), new JvmOption("-XX:+PrintGCDateStamps"), new JvmOption("-XX:+PrintTenuringDistribution"), new JvmOption("-Xloggc:" + gcLogPath));
    }
}

