/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.config.library;

import java.util.Collections;
import java.util.List;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.allocation.AllocationUnit;
import org.quickperf.jvm.allocation.JvmAllocationUnitFormatter;
import org.quickperf.jvm.annotations.Xmx;
import org.quickperf.testlauncher.AnnotationToJvmOptionConverter;
import org.quickperf.testlauncher.JvmOption;

class XmxAnnotToJvmOptionConverter
implements AnnotationToJvmOptionConverter<Xmx> {
    static final XmxAnnotToJvmOptionConverter INSTANCE = new XmxAnnotToJvmOptionConverter();
    private final JvmAllocationUnitFormatter jvmAllocationUnitFormatter = JvmAllocationUnitFormatter.INSTANCE;

    private XmxAnnotToJvmOptionConverter() {
    }

    public List<JvmOption> convertToJvmOptions(Xmx xmx, WorkingFolder workingFolder) {
        AllocationUnit allocationUnit = xmx.unit();
        String jvmParamOption = "-Xmx" + xmx.value() + this.jvmAllocationUnitFormatter.format(allocationUnit);
        JvmOption jvmOption = new JvmOption(jvmParamOption);
        return Collections.singletonList(jvmOption);
    }
}

