/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.config.library;

import java.util.Collections;
import java.util.List;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.allocation.AllocationUnit;
import org.quickperf.jvm.allocation.JvmAllocationUnitFormatter;
import org.quickperf.jvm.annotations.Xms;
import org.quickperf.testlauncher.AnnotationToJvmOptionConverter;
import org.quickperf.testlauncher.JvmOption;

class XmsAnnotToJvmOptionConverter
implements AnnotationToJvmOptionConverter<Xms> {
    static final XmsAnnotToJvmOptionConverter INSTANCE = new XmsAnnotToJvmOptionConverter();
    private final JvmAllocationUnitFormatter jvmAllocationUnitFormatter = JvmAllocationUnitFormatter.INSTANCE;

    private XmsAnnotToJvmOptionConverter() {
    }

    public List<JvmOption> convertToJvmOptions(Xms xms, WorkingFolder workingFolder) {
        AllocationUnit allocationUnit = xms.unit();
        String jvmOptionAsString = "-Xms" + xms.value() + this.jvmAllocationUnitFormatter.format(allocationUnit);
        JvmOption jvmOption = new JvmOption(jvmOptionAsString);
        return Collections.singletonList(jvmOption);
    }
}

