/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.config.library;

import java.util.ArrayList;
import java.util.List;
import org.quickperf.WorkingFolder;
import org.quickperf.jvm.allocation.AllocationUnit;
import org.quickperf.jvm.allocation.JvmAllocationUnitFormatter;
import org.quickperf.jvm.annotations.HeapSize;
import org.quickperf.testlauncher.AnnotationToJvmOptionConverter;
import org.quickperf.testlauncher.JvmOption;

class HeapSizeAnnotToJvmOptionConverter
implements AnnotationToJvmOptionConverter<HeapSize> {
    static final HeapSizeAnnotToJvmOptionConverter INSTANCE = new HeapSizeAnnotToJvmOptionConverter();
    private final JvmAllocationUnitFormatter jvmAllocationUnitFormatter = JvmAllocationUnitFormatter.INSTANCE;

    private HeapSizeAnnotToJvmOptionConverter() {
    }

    public List<JvmOption> convertToJvmOptions(HeapSize heapSize, WorkingFolder workingFolder) {
        ArrayList<JvmOption> jvmOptions = new ArrayList<JvmOption>(2);
        AllocationUnit allocationUnit = heapSize.unit();
        int heapValue = heapSize.value();
        String allocationUnitAsString = this.jvmAllocationUnitFormatter.format(allocationUnit);
        String xmsJvmOptionAsString = "-Xms" + heapValue + allocationUnitAsString;
        jvmOptions.add(new JvmOption(xmsJvmOptionAsString));
        String xmxJvmOptionAsString = "-Xmx" + heapValue + allocationUnitAsString;
        jvmOptions.add(new JvmOption(xmxJvmOptionAsString));
        return jvmOptions;
    }
}

