/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation.bytewatcher;

import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ByteWatcherSingleThread {
    private static final String ALLOCATED = " allocated ";
    private static final String GET_THREAD_ALLOCATED_BYTES = "getThreadAllocatedBytes";
    private static final String[] SIGNATURE = new String[]{Long.TYPE.getName()};
    private static final MBeanServer mBeanServer;
    private static final ObjectName name;
    private final Thread thread;
    private final Object[] PARAMS;
    private final AtomicLong allocated = new AtomicLong();
    private final long MEASURING_COST_IN_BYTES;
    private final long tid;
    private final boolean checkThreadSafety;

    public ByteWatcherSingleThread() {
        this(Thread.currentThread(), true);
    }

    public ByteWatcherSingleThread(Thread thread) {
        this(thread, false);
    }

    private ByteWatcherSingleThread(Thread thread, boolean checkThreadSafety) {
        this.checkThreadSafety = checkThreadSafety;
        this.tid = thread.getId();
        this.thread = thread;
        this.PARAMS = new Object[]{this.tid};
        long calibrate = this.threadAllocatedBytes();
        for (int repeats = 0; repeats < 10; ++repeats) {
            for (int i = 0; i < 10000; ++i) {
                calibrate = this.threadAllocatedBytes();
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.MEASURING_COST_IN_BYTES = this.threadAllocatedBytes() - calibrate;
        this.reset();
    }

    public long getMeasuringCostInBytes() {
        return this.MEASURING_COST_IN_BYTES;
    }

    public void reset() {
        this.checkThreadSafety();
        this.allocated.set(this.threadAllocatedBytes());
    }

    long threadAllocatedBytes() {
        try {
            return (Long)mBeanServer.invoke(name, GET_THREAD_ALLOCATED_BYTES, this.PARAMS, SIGNATURE);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public long calculateAllocations() {
        this.checkThreadSafety();
        return this.threadAllocatedBytes() - this.MEASURING_COST_IN_BYTES - this.allocated.get();
    }

    private void checkThreadSafety() {
        if (this.checkThreadSafety && this.tid != Thread.currentThread().getId()) {
            throw new IllegalStateException("AllocationMeasure must not be used over more than 1 thread.");
        }
    }

    public Thread getThread() {
        return this.thread;
    }

    public String toString() {
        return this.thread.getName() + ALLOCATED + this.calculateAllocations();
    }

    static {
        try {
            name = new ObjectName("java.lang:type=Threading");
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        catch (MalformedObjectNameException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

