/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation.bytewatcher;

import org.quickperf.TestExecutionContext;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.AllocationRepository;
import org.quickperf.jvm.allocation.bytewatcher.ByteWatcherSingleThread;
import org.quickperf.perfrecording.RecordablePerformance;

public class ByteWatcherRecorder
implements RecordablePerformance<Allocation> {
    private AllocationRepository allocationRepository = new AllocationRepository();
    private ByteWatcherSingleThread byteWatcher;

    public void startRecording(TestExecutionContext testExecutionContext) {
        this.byteWatcher = new ByteWatcherSingleThread(Thread.currentThread());
        this.byteWatcher.reset();
    }

    public void stopRecording(TestExecutionContext testExecutionContext) {
        long calculatedAllocation = this.byteWatcher.calculateAllocations();
        int runnerAllocationOffset = testExecutionContext.getRunnerAllocationOffset();
        long allocationInBytes = calculatedAllocation - (long)runnerAllocationOffset;
        this.allocationRepository.saveAllocationInBytes(allocationInBytes, testExecutionContext);
    }

    public Allocation findRecord(TestExecutionContext testExecutionContext) {
        this.allocationRepository = new AllocationRepository();
        return this.allocationRepository.findAllocation(testExecutionContext);
    }

    public void cleanResources() {
    }
}

