/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.ByteAllocationMeasureFormatter;
import org.quickperf.jvm.annotations.ExpectNoHeapAllocation;
import org.quickperf.measure.PerfMeasure;

public class NoHeapAllocationPerfVerifier
implements VerifiablePerformanceIssue<ExpectNoHeapAllocation, Allocation> {
    public static final NoHeapAllocationPerfVerifier INSTANCE = new NoHeapAllocationPerfVerifier();
    private final ByteAllocationMeasureFormatter byteAllocationMeasureFormatter = ByteAllocationMeasureFormatter.INSTANCE;

    private NoHeapAllocationPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectNoHeapAllocation annotation, Allocation measuredAllocation) {
        if (!Allocation.ZERO.isEqualTo((PerfMeasure)measuredAllocation)) {
            String assertionMessage = "Expected no heap allocation (test method thread) but is " + this.byteAllocationMeasureFormatter.formatAndAppendAllocationInBytes(measuredAllocation) + ".";
            String description = assertionMessage + System.lineSeparator() + measuredAllocation.getComment();
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }
}

