/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation;

import java.io.PrintWriter;
import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.ByteAllocationMeasureFormatter;
import org.quickperf.jvm.annotations.MeasureHeapAllocation;
import org.quickperf.writer.PrintWriterBuilder;
import org.quickperf.writer.WriterFactory;

public class MeasureHeapAllocationPerfVerifier
implements VerifiablePerformanceIssue<MeasureHeapAllocation, Allocation> {
    public static final VerifiablePerformanceIssue INSTANCE = new MeasureHeapAllocationPerfVerifier();
    private final ByteAllocationMeasureFormatter byteAllocationMeasureFormatter = ByteAllocationMeasureFormatter.INSTANCE;

    private MeasureHeapAllocationPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(MeasureHeapAllocation annotation, Allocation measuredAllocation) {
        String allocationAsString = this.byteAllocationMeasureFormatter.formatAndAppendAllocationInBytes(measuredAllocation);
        Class<? extends WriterFactory> writerFactoryClass = annotation.writerFactory();
        try (PrintWriter pw = PrintWriterBuilder.INSTANCE.buildPrintWriterFrom(writerFactoryClass);){
            pw.printf(annotation.format(), allocationAsString);
        }
        return PerfIssue.NONE;
    }
}

