/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.jvm.allocation;

import org.quickperf.issue.PerfIssue;
import org.quickperf.issue.VerifiablePerformanceIssue;
import org.quickperf.jvm.allocation.Allocation;
import org.quickperf.jvm.allocation.ByteAllocationMeasureFormatter;
import org.quickperf.jvm.annotations.ExpectMaxHeapAllocation;
import org.quickperf.measure.PerfMeasure;

public class MaxHeapAllocationPerfVerifier
implements VerifiablePerformanceIssue<ExpectMaxHeapAllocation, Allocation> {
    public static final VerifiablePerformanceIssue INSTANCE = new MaxHeapAllocationPerfVerifier();
    private final ByteAllocationMeasureFormatter byteAllocationMeasureFormatter = ByteAllocationMeasureFormatter.INSTANCE;

    private MaxHeapAllocationPerfVerifier() {
    }

    public PerfIssue verifyPerfIssue(ExpectMaxHeapAllocation annotation, Allocation measuredAllocation) {
        Allocation maxExpectedAllocation = new Allocation(Double.valueOf(annotation.value()), annotation.unit());
        if (maxExpectedAllocation.isLessThan((PerfMeasure)measuredAllocation)) {
            String assertionMessage = "Expected heap allocation (test method thread) to be less than " + this.byteAllocationMeasureFormatter.format(maxExpectedAllocation) + " but is " + this.byteAllocationMeasureFormatter.formatAndAppendAllocationInBytes(measuredAllocation) + ".";
            String description = assertionMessage + System.lineSeparator() + measuredAllocation.getComment();
            return new PerfIssue(description);
        }
        return PerfIssue.NONE;
    }
}

