/*
 * Decompiled with CFR 0.152.
 */
package org.quickperf.junit5;

import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.quickperf.issue.TestIssue;
import org.quickperf.testlauncher.TestRunnerFromMain;

class JUnit5TestRunner
implements TestRunnerFromMain.FrameworkTestRunner {
    JUnit5TestRunner() {
    }

    public TestIssue executeTestMethod(Class<?> testClass, String methodName) {
        TestExecutionSummary testResult = JUnit5TestRunner.runTestMethod(testClass, methodName);
        List failures = testResult.getFailures();
        List<Throwable> jUnit5failuresAsThrowables = this.convertToThrowables(failures);
        return TestIssue.buildInNewJvmFrom(jUnit5failuresAsThrowables);
    }

    private List<Throwable> convertToThrowables(List<TestExecutionSummary.Failure> failures) {
        return failures.stream().map(TestExecutionSummary.Failure::getException).collect(Collectors.toList());
    }

    private static TestExecutionSummary runTestMethod(Class<?> testClass, String methodName) {
        MethodSelector testMethodSelector = DiscoverySelectors.selectMethod(testClass, (String)methodName);
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{testMethodSelector}).build();
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        Launcher launcher = LauncherFactory.create();
        launcher.execute(request, new TestExecutionListener[]{listener});
        return listener.getSummary();
    }
}

