/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import quickfix.Group;
import quickfix.Message;
import quickfix.MessageFactory;
import quickfix.MessageUtils;
import quickfix.field.ApplVerID;

public class DefaultMessageFactory
implements MessageFactory {
    private final Map<String, MessageFactory> messageFactories = new ConcurrentHashMap<String, MessageFactory>();
    private final ApplVerID defaultApplVerID;

    public DefaultMessageFactory() {
        this("9");
    }

    public DefaultMessageFactory(String defaultApplVerID) {
        Objects.requireNonNull(defaultApplVerID, "defaultApplVerID");
        this.defaultApplVerID = new ApplVerID(defaultApplVerID);
        this.addFactory("FIX.4.0");
        this.addFactory("FIX.4.1");
        this.addFactory("FIX.4.2");
        this.addFactory("FIX.4.3");
        this.addFactory("FIX.4.4");
        this.addFactory("FIXT.1.1");
        this.addFactory("FIX.5.0");
        this.addFactory("FIX.5.0SP1");
        this.addFactory("FIX.5.0SP2");
    }

    private void addFactory(String beginString) {
        String packageVersion = beginString.replace(".", "").toLowerCase();
        try {
            this.addFactory(beginString, "quickfix." + packageVersion + ".MessageFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void addFactory(String beginString, String factoryClassName) throws ClassNotFoundException {
        Class<?> factoryClass = null;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            Thread.currentThread().getContextClassLoader().loadClass(factoryClassName);
        }
        if (factoryClass != null) {
            this.addFactory(beginString, factoryClass);
        }
    }

    public void addFactory(String beginString, Class<? extends MessageFactory> factoryClass) {
        try {
            MessageFactory factory = factoryClass.newInstance();
            this.messageFactories.put(beginString, factory);
        }
        catch (Exception e) {
            throw new RuntimeException("can't instantiate " + factoryClass.getName(), e);
        }
    }

    @Override
    public Message create(String beginString, String msgType) {
        return this.create(beginString, this.defaultApplVerID, msgType);
    }

    @Override
    public Message create(String beginString, ApplVerID applVerID, String msgType) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (beginString.equals("FIXT.1.1") && !MessageUtils.isAdminMessage(msgType)) {
            if (applVerID == null) {
                applVerID = new ApplVerID(this.defaultApplVerID.getValue());
            }
            messageFactory = this.messageFactories.get(MessageUtils.toBeginString(applVerID));
        }
        if (messageFactory != null) {
            return messageFactory.create(beginString, applVerID, msgType);
        }
        Message message = new Message();
        message.getHeader().setString(35, msgType);
        return message;
    }

    @Override
    public Group create(String beginString, String msgType, int correspondingFieldID) {
        MessageFactory messageFactory = this.messageFactories.get(beginString);
        if (messageFactory != null) {
            return messageFactory.create(beginString, msgType, correspondingFieldID);
        }
        throw new IllegalArgumentException("Unsupported FIX version: " + beginString);
    }
}

