/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.time.LocalDateTime;
import quickfix.Field;
import quickfix.UtcTimestampPrecision;

public class UtcTimeStampField
extends Field<LocalDateTime> {
    private UtcTimestampPrecision precision = UtcTimestampPrecision.MILLIS;

    public UtcTimeStampField(int field) {
        super(field, LocalDateTime.now());
    }

    protected UtcTimeStampField(int field, LocalDateTime data) {
        super(field, data);
    }

    protected UtcTimeStampField(int field, LocalDateTime data, UtcTimestampPrecision precision) {
        super(field, data);
        this.precision = precision;
    }

    public UtcTimeStampField(int field, boolean includeMilliseconds) {
        super(field, LocalDateTime.now());
        this.precision = includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS;
    }

    public UtcTimeStampField(int field, UtcTimestampPrecision precision) {
        super(field, LocalDateTime.now());
        this.precision = precision;
    }

    protected UtcTimeStampField(int field, LocalDateTime data, boolean includeMilliseconds) {
        super(field, data);
        this.precision = includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS;
    }

    public UtcTimestampPrecision getPrecision() {
        return this.precision;
    }

    public void setValue(LocalDateTime value) {
        this.setObject(value);
    }

    public LocalDateTime getValue() {
        return (LocalDateTime)this.getObject();
    }

    public boolean valueEquals(LocalDateTime value) {
        return this.getValue().equals(value);
    }
}

