/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.message2;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.python.icu.message2.Selector;
import org.python.icu.message2.SelectorFactory;

class TextSelectorFactory
implements SelectorFactory {
    TextSelectorFactory() {
    }

    @Override
    public Selector createSelector(Locale locale, Map<String, Object> fixedOptions) {
        return new TextSelector();
    }

    private static class TextSelector
    implements Selector {
        private TextSelector() {
        }

        @Override
        public List<String> matches(Object value, List<String> keys, Map<String, Object> variableOptions) {
            ArrayList<String> result = new ArrayList<String>();
            if (value == null) {
                return result;
            }
            for (String key : keys) {
                if (!this.matches(value, key)) continue;
                result.add(key);
            }
            result.sort(String::compareTo);
            return result;
        }

        private boolean matches(Object value, String key) {
            if ("*".equals(key)) {
                return true;
            }
            return key.equals(Objects.toString(value));
        }
    }
}

