/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyXRange;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.izip$PyExposer;

@ExposedType(name="itertools.izip", base=PyObject.class, doc="izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.")
public class izip
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String izip_doc = "izip(iter1 [,iter2 [...]]) --> izip object\n\nReturn an izip object whose .next() method returns a tuple where\nthe i-th element comes from the i-th iterable argument.  The .next()\nmethod continues until the shortest iterable in the argument sequence\nis exhausted and then it raises StopIteration.  Works like the zip()\nfunction but consumes less memory by returning an iterator instead of\na list.";

    public izip() {
    }

    public izip(PyType subType) {
        super(subType);
    }

    public izip(PyObject ... args) {
        this.izip___init__(args);
    }

    @ExposedNew
    final void izip___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError(String.format("izip does not take keyword arguments", new Object[0]));
        }
        this.izip___init__(args);
    }

    private void izip___init__(PyObject[] argstar) {
        final int itemsize = argstar.length;
        if (itemsize == 0) {
            this.iter = (PyIterator)new PyXRange(0).__iter__();
            return;
        }
        final PyObject[] iters = new PyObject[itemsize];
        for (int i = 0; i < itemsize; ++i) {
            PyObject iter = argstar[i].__iter__();
            if (iter == null) {
                throw Py.TypeError("izip argument #" + (i + 1) + " must support iteration");
            }
            iters[i] = iter;
        }
        this.iter = new itertools.ItertoolsIterator(){

            @Override
            public PyObject __iternext__() {
                if (itemsize == 0) {
                    return null;
                }
                PyObject[] next = new PyObject[itemsize];
                for (int i = 0; i < itemsize; ++i) {
                    PyObject item = this.nextElement(iters[i]);
                    if (item == null) {
                        return null;
                    }
                    next[i] = item;
                }
                return new PyTuple(next);
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(izip.class, new izip$PyExposer());
        TYPE = PyType.fromClass(izip.class);
    }
}

