/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.tls;

import org.python.bouncycastle.crypto.tls.DTLSReplayWindow;
import org.python.bouncycastle.crypto.tls.TlsCipher;

class DTLSEpoch {
    private final DTLSReplayWindow replayWindow = new DTLSReplayWindow();
    private final int epoch;
    private final TlsCipher cipher;
    private long sequence_number = 0L;

    DTLSEpoch(int n, TlsCipher tlsCipher) {
        if (n < 0) {
            throw new IllegalArgumentException("'epoch' must be >= 0");
        }
        if (tlsCipher == null) {
            throw new IllegalArgumentException("'cipher' cannot be null");
        }
        this.epoch = n;
        this.cipher = tlsCipher;
    }

    long allocateSequenceNumber() {
        return this.sequence_number++;
    }

    TlsCipher getCipher() {
        return this.cipher;
    }

    int getEpoch() {
        return this.epoch;
    }

    DTLSReplayWindow getReplayWindow() {
        return this.replayWindow;
    }

    long getSequence_number() {
        return this.sequence_number;
    }
}

