/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.dom;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DOMMessageFormatter {
    public static final String DOM_DOMAIN = "http://www.w3.org/dom/DOMTR";
    public static final String XML_DOMAIN = "http://www.w3.org/TR/1998/REC-xml-19980210";
    public static final String SERIALIZER_DOMAIN = "http://apache.org/xml/serializer";
    private static ResourceBundle domResourceBundle = null;
    private static ResourceBundle xmlResourceBundle = null;
    private static ResourceBundle serResourceBundle = null;
    private static Locale locale = null;

    DOMMessageFormatter() {
        locale = Locale.getDefault();
    }

    public static String formatMessage(String string2, String string3, Object[] objectArray) throws MissingResourceException {
        String string4;
        ResourceBundle resourceBundle = DOMMessageFormatter.getResourceBundle(string2);
        if (resourceBundle == null) {
            DOMMessageFormatter.init();
            resourceBundle = DOMMessageFormatter.getResourceBundle(string2);
            if (resourceBundle == null) {
                throw new MissingResourceException("Unknown domain" + string2, null, string3);
            }
        }
        try {
            string4 = string3 + ": " + resourceBundle.getString(string3);
            if (objectArray != null) {
                try {
                    string4 = MessageFormat.format(string4, objectArray);
                }
                catch (Exception exception) {
                    string4 = resourceBundle.getString("FormatFailed");
                    string4 = string4 + " " + resourceBundle.getString(string3);
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            String string5 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(string3, string5, string3);
        }
        if (string4 == null) {
            string4 = string3;
            if (objectArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer(string4);
                stringBuffer.append('?');
                int n = 0;
                while (n < objectArray.length) {
                    if (n > 0) {
                        stringBuffer.append('&');
                    }
                    stringBuffer.append(String.valueOf(objectArray[n]));
                    ++n;
                }
            }
        }
        return string4;
    }

    static ResourceBundle getResourceBundle(String string2) {
        if (string2 == DOM_DOMAIN || string2.equals(DOM_DOMAIN)) {
            return domResourceBundle;
        }
        if (string2 == XML_DOMAIN || string2.equals(XML_DOMAIN)) {
            return xmlResourceBundle;
        }
        if (string2 == SERIALIZER_DOMAIN || string2.equals(SERIALIZER_DOMAIN)) {
            return serResourceBundle;
        }
        return null;
    }

    public static void init() {
        if (locale != null) {
            domResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.DOMMessages", locale);
            serResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.XMLSerializerMessages", locale);
            xmlResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.XMLMessages", locale);
        } else {
            domResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.DOMMessages");
            serResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.XMLSerializerMessages");
            xmlResourceBundle = ResourceBundle.getBundle("org.python.apache.xerces.impl.msg.XMLMessages");
        }
    }

    public static void setLocale(Locale locale2) {
        locale = locale2;
    }
}

