/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal.matcherstrategies;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.powermock.reflect.exceptions.FieldNotFoundException;
import org.powermock.reflect.internal.matcherstrategies.FieldMatcherStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldAnnotationMatcherStrategy
extends FieldMatcherStrategy {
    final Class<? extends Annotation>[] annotations;

    public FieldAnnotationMatcherStrategy(Class<? extends Annotation>[] annotations) {
        if (annotations == null || annotations.length == 0) {
            throw new IllegalArgumentException("You must specify atleast one annotation.");
        }
        this.annotations = annotations;
    }

    @Override
    public boolean matches(Field field) {
        for (Class<? extends Annotation> annotation : this.annotations) {
            if (!field.isAnnotationPresent(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notFound(Class<?> type, boolean isInstanceField) throws FieldNotFoundException {
        throw new FieldNotFoundException("No field that has any of the annotation types \"" + this.getAnnotationNames() + "\" could be found in the class hierarchy of " + type.getName() + ".");
    }

    public String toString() {
        return "annotations " + this.getAnnotationNames();
    }

    private String getAnnotationNames() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.annotations.length; ++i) {
            builder.append(this.annotations[i].getName());
            if (i == this.annotations.length - 1) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

