/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.powermock.core.MockRepository;
import org.powermock.reflect.Whitebox;
import org.powermock.reflect.internal.WhiteboxImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuppressCode {
    public static synchronized void suppressConstructor(Constructor<?> ... constructors) {
        if (constructors == null) {
            throw new IllegalArgumentException("constructors cannot be null.");
        }
        for (Constructor<?> constructor : constructors) {
            MockRepository.addConstructorToSuppress(constructor);
            Class<?> declaringClass = constructor.getDeclaringClass();
            if (declaringClass == null) continue;
            SuppressCode.suppressConstructor(declaringClass.getSuperclass());
        }
    }

    public static synchronized void suppressSpecificConstructor(Class<?> clazz, Class<?> ... parameterTypes) {
        MockRepository.addConstructorToSuppress((Constructor)Whitebox.getConstructor(clazz, (Class[])parameterTypes));
    }

    public static synchronized void suppressConstructor(Class<?> ... classes) {
        Class<?>[] classArray = classes;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            for (Class<?> tempClass = clazz = classArray[i]; tempClass != Object.class; tempClass = tempClass.getSuperclass()) {
                SuppressCode.suppressConstructor(tempClass, false);
            }
        }
    }

    public static synchronized void suppressConstructor(Class<?> clazz, boolean excludePrivateConstructors) {
        Constructor<?>[] ctors = null;
        ctors = excludePrivateConstructors ? clazz.getConstructors() : clazz.getDeclaredConstructors();
        for (Constructor<?> ctor : ctors) {
            MockRepository.addConstructorToSuppress(ctor);
        }
    }

    public static synchronized void suppressField(Field ... fields) {
        for (Field field : fields) {
            MockRepository.addFieldToSuppress((Field)field);
        }
    }

    public static synchronized void suppressField(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            throw new IllegalArgumentException("You must supply at least one class.");
        }
        for (Class<?> clazz : classes) {
            SuppressCode.suppressField(clazz.getDeclaredFields());
        }
    }

    public static synchronized void suppressField(Class<?> clazz, String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            SuppressCode.suppressField(new Class[]{clazz});
        } else {
            for (Field field : Whitebox.getFields(clazz, (String[])fieldNames)) {
                MockRepository.addFieldToSuppress((Field)field);
            }
        }
    }

    public static synchronized void suppressMethod(Method ... methods) {
        for (Method method : methods) {
            MockRepository.addMethodToSuppress((Method)method);
        }
    }

    public static synchronized void suppressMethod(Class<?> cls, Class<?> ... additionalClasses) {
        SuppressCode.suppressMethod(cls, false);
        for (Class<?> clazz : additionalClasses) {
            SuppressCode.suppressMethod(clazz, false);
        }
    }

    public static synchronized void suppressMethod(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            SuppressCode.suppressMethod(clazz, false);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String methodName, String ... additionalMethodNames) {
        for (Method method : Whitebox.getMethods(clazz, (String[])new String[]{methodName})) {
            MockRepository.addMethodToSuppress((Method)method);
        }
        if (additionalMethodNames != null && additionalMethodNames.length > 0) {
            for (Method method : Whitebox.getMethods(clazz, (String[])additionalMethodNames)) {
                MockRepository.addMethodToSuppress((Method)method);
            }
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String[] methodNames) {
        for (Method method : Whitebox.getMethods(clazz, (String[])methodNames)) {
            MockRepository.addMethodToSuppress((Method)method);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, boolean excludePrivateMethods) {
        Method[] methods = null;
        methods = excludePrivateMethods ? clazz.getMethods() : clazz.getDeclaredMethods();
        for (Method method : methods) {
            MockRepository.addMethodToSuppress((Method)method);
        }
    }

    public static synchronized void suppressMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        Method method = null;
        method = parameterTypes.length > 0 ? Whitebox.getMethod(clazz, (String)methodName, (Class[])parameterTypes) : WhiteboxImpl.findMethodOrThrowException(clazz, (String)methodName, (Class[])parameterTypes);
        MockRepository.addMethodToSuppress((Method)method);
    }
}

