/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.mockmaker;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.MockHandler;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.plugins.MockMaker;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.mockmaker.MockMakerLoader;
import org.powermock.configuration.GlobalConfiguration;

public class PowerMockMaker
implements MockMaker {
    private final MockMaker mockMaker = new MockMakerLoader().load(GlobalConfiguration.mockitoConfiguration());

    public <T> T createMock(MockCreationSettings<T> settings, MockHandler handler) {
        return (T)this.mockMaker.createMock(settings, handler);
    }

    public MockHandler getHandler(Object mock) {
        if (mock instanceof Class) {
            return new PowerMockInternalMockHandler((Class)mock);
        }
        return this.mockMaker.getHandler(mock);
    }

    public void resetMock(Object mock, MockHandler newHandler, MockCreationSettings settings) {
        this.mockMaker.resetMock(mock, newHandler, settings);
    }

    public MockMaker.TypeMockability isTypeMockable(Class<?> type) {
        return this.mockMaker.isTypeMockable(type);
    }

    MockMaker getMockMaker() {
        return this.mockMaker;
    }

    private static class PowerMockInternalMockHandler
    implements InternalMockHandler<Class> {
        private final Class<?> mock;

        private PowerMockInternalMockHandler(Class<?> mock) {
            this.mock = mock;
        }

        public MockCreationSettings<Class> getMockSettings() {
            MockSettingsImpl mockSettings = new MockSettingsImpl();
            mockSettings.setMockName((MockName)new MockNameImpl(this.mock.getName()));
            mockSettings.setTypeToMock(this.mock);
            return mockSettings;
        }

        public void setAnswersForStubbing(List<Answer<?>> list) {
        }

        public InvocationContainer getInvocationContainer() {
            return null;
        }

        public Object handle(Invocation invocation) throws Throwable {
            return null;
        }
    }
}

