/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.internal.expectation;

import java.lang.reflect.Method;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.powermock.api.mockito.expectation.WithOrWithoutExpectedArguments;

public class DefaultMethodExpectationSetup<T>
implements WithOrWithoutExpectedArguments<T> {
    private final Object object;
    private final Method method;

    public DefaultMethodExpectationSetup(Object object, Method method) {
        if (object == null) {
            throw new IllegalArgumentException("object to expect cannot be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("method to expect cannot be null");
        }
        this.object = object;
        this.method = method;
        this.method.setAccessible(true);
    }

    public OngoingStubbing<T> withArguments(Object firstArgument, Object ... additionalArguments) throws Exception {
        if (additionalArguments == null || additionalArguments.length == 0) {
            return Mockito.when((Object)this.method.invoke(this.object, firstArgument));
        }
        return Mockito.when((Object)this.method.invoke(this.object, DefaultMethodExpectationSetup.join(firstArgument, additionalArguments)));
    }

    public OngoingStubbing<T> withNoArguments() throws Exception {
        return Mockito.when((Object)this.method.invoke(this.object, new Object[0]));
    }

    private static Object[] join(Object o, Object[] array) {
        Object[] res = new Object[array.length + 1];
        res[0] = o;
        System.arraycopy(array, 0, res, 1, array.length);
        return res;
    }
}

