/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.postgresql.PGConnection;

public class TestServer {
    public static void main(String[] stringArray) {
        if (stringArray.length != 4 && stringArray.length != 3) {
            System.err.println("Usage: java examples/TestServer dburl user pass [tablename]");
            System.err.println();
            System.err.println("dburl has the following format:");
            System.err.println("jdbc:postgresql://HOST:PORT/DATABASENAME");
            System.err.println("tablename is 'jdbc_test' by default.");
            System.exit(1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        String string4 = "jdbc_test";
        String string5 = "drop table " + string4;
        String string6 = "create table " + string4 + " (geom geometry, id int4)";
        String string7 = "insert into " + string4 + " values ('POINT (10 10 10)',1)";
        String string8 = "insert into " + string4 + " values ('POLYGON ((0 0 0,0 10 0,10 10 0,10 0 0,0 0 0))',2)";
        try {
            System.out.println("Creating JDBC connection...");
            Class.forName("org.postgresql.Driver");
            Connection connection = DriverManager.getConnection(string, string2, string3);
            System.out.println("Adding geometric type entries...");
            if (connection.getClass().getName().equals("org.postgresql.jdbc2.Connection")) {
                ((org.postgresql.Connection)connection).addDataType("geometry", "org.postgis.PGgeometry");
                ((org.postgresql.Connection)connection).addDataType("box3d", "org.postgis.PGbox3d");
            } else {
                ((PGConnection)connection).addDataType("geometry", "org.postgis.PGgeometry");
                ((PGConnection)connection).addDataType("box3d", "org.postgis.PGbox3d");
            }
            Statement statement = connection.createStatement();
            System.out.println("Creating table with geometric types...");
            try {
                statement.execute(string5);
            }
            catch (Exception exception) {
                System.out.println("Error dropping old table: " + exception.getMessage());
            }
            statement.execute(string6);
            System.out.println("Inserting point...");
            statement.execute(string7);
            System.out.println("Inserting polygon...");
            statement.execute(string8);
            System.out.println("Done.");
            statement = connection.createStatement();
            System.out.println("Querying table...");
            ResultSet resultSet = statement.executeQuery("select asText(geom),id from " + string4);
            while (resultSet.next()) {
                Object object = resultSet.getObject(1);
                int n = resultSet.getInt(2);
                System.out.println("Row " + n + ":");
                System.out.println(object.toString());
            }
            statement.close();
            connection.close();
        }
        catch (Exception exception) {
            System.err.println("Aborted due to error:");
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

