/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.netty.timeout;

import play.shaded.ahc.io.netty.util.Timeout;
import play.shaded.ahc.org.asynchttpclient.netty.NettyResponseFuture;
import play.shaded.ahc.org.asynchttpclient.netty.channel.Channels;
import play.shaded.ahc.org.asynchttpclient.netty.handler.StreamedResponsePublisher;
import play.shaded.ahc.org.asynchttpclient.netty.request.NettyRequestSender;
import play.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import play.shaded.ahc.org.asynchttpclient.netty.timeout.TimeoutsHolder;
import play.shaded.ahc.org.asynchttpclient.util.DateUtils;
import play.shaded.ahc.org.asynchttpclient.util.StringBuilderPool;

public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;

    ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, TimeoutsHolder timeoutsHolder, int readTimeout) {
        super(nettyResponseFuture, requestSender, timeoutsHolder);
        this.readTimeout = readTimeout;
    }

    @Override
    public void run(Timeout timeout) {
        if (this.done.getAndSet(true) || this.requestSender.isClosed()) {
            return;
        }
        if (this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.unpreciseMillisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L && !this.isReactiveWithNoOutstandingRequest()) {
            StringBuilder sb = StringBuilderPool.DEFAULT.stringBuilder().append("Read timeout to ");
            this.appendRemoteAddress(sb);
            String message = sb.append(" after ").append(this.readTimeout).append(" ms").toString();
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
            this.timeoutsHolder.cancel();
        } else {
            this.done.set(false);
            this.timeoutsHolder.startReadTimeout(this);
        }
    }

    private boolean isReactiveWithNoOutstandingRequest() {
        Object attribute = Channels.getAttribute(this.nettyResponseFuture.channel());
        return attribute instanceof StreamedResponsePublisher && !((StreamedResponsePublisher)attribute).hasOutstandingRequest();
    }
}

