/*
 * Decompiled with CFR 0.152.
 */
package play.inject;

import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.function.Supplier;
import play.inject.Binding;
import play.inject.QualifierAnnotation;
import scala.Option;
import scala.jdk.javaapi.FunctionConverters;
import scala.jdk.javaapi.OptionConverters;

public final class BindingKey<T> {
    private final play.api.inject.BindingKey<T> underlying;

    public BindingKey(Class<T> clazz, Optional<QualifierAnnotation> optional) {
        this(play.api.inject.BindingKey.apply(clazz, (Option<play.api.inject.QualifierAnnotation>)OptionConverters.toScala(optional.map(QualifierAnnotation::asScala))));
    }

    public BindingKey(play.api.inject.BindingKey<T> bindingKey) {
        this.underlying = bindingKey;
    }

    public BindingKey(Class<T> clazz) {
        this(clazz, Optional.empty());
    }

    public Class<T> getClazz() {
        return this.underlying.clazz();
    }

    public Optional<QualifierAnnotation> getQualifier() {
        return OptionConverters.toJava(this.underlying.qualifier()).map(play.api.inject.QualifierAnnotation::asJava);
    }

    public <A extends Annotation> BindingKey<T> qualifiedWith(A a) {
        return this.underlying.qualifiedWith(a).asJava();
    }

    public <A extends Annotation> BindingKey<T> qualifiedWith(Class<A> clazz) {
        return this.underlying.qualifiedWith(clazz).asJava();
    }

    public BindingKey<T> qualifiedWith(String string) {
        return this.underlying.qualifiedWith(string).asJava();
    }

    public Binding<T> to(Class<? extends T> clazz) {
        return this.underlying.to(clazz).asJava();
    }

    public Binding<T> to(Provider<? extends T> provider) {
        return this.underlying.to(provider).asJava();
    }

    public <A extends T> Binding<T> to(Supplier<A> supplier) {
        return this.underlying.to(FunctionConverters.asScalaFromSupplier(supplier)).asJava();
    }

    public Binding<T> to(BindingKey<? extends T> bindingKey) {
        return this.underlying.to(bindingKey.asScala()).asJava();
    }

    public <P extends Provider<? extends T>> Binding<T> toProvider(Class<P> clazz) {
        return this.underlying.toProvider(clazz).asJava();
    }

    public Binding<T> toInstance(T t) {
        return this.underlying.toInstance(t).asJava();
    }

    public Binding<T> toSelf() {
        return this.underlying.toSelf().asJava();
    }

    public String toString() {
        return this.underlying.toString();
    }

    public play.api.inject.BindingKey<T> asScala() {
        return this.underlying;
    }
}

