/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.crypto;

import jakarta.inject.Inject;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Clock;
import play.api.libs.Codecs$;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CookieSigner;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000514A\u0001D\u0007\u0001-!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0011\u0015q\u0003\u0001\"\u00010\u0011\u001da\u0004A1A\u0005\nuBa\u0001\u0012\u0001!\u0002\u0013q\u0004\"B#\u0001\t\u00031\u0005\"\u0002+\u0001\t\u0003)\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u0002/\u0001\t\u0003Y\u0006\"B/\u0001\t\u0003q\u0006\"\u00024\u0001\t\u00139'A\u0006#fM\u0006,H\u000e^\"T%\u001a#vn[3o'&<g.\u001a:\u000b\u00059y\u0011AB2ssB$xN\u0003\u0002\u0011#\u0005!A.\u001b2t\u0015\t\u00112#A\u0002ba&T\u0011\u0001F\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u00019R\u0004\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=}i\u0011!D\u0005\u0003A5\u0011qbQ*S\rR{7.\u001a8TS\u001etWM]\u0001\u0007g&<g.\u001a:\u0011\u0005y\u0019\u0013B\u0001\u0013\u000e\u00051\u0019un\\6jKNKwM\\3s\u0003\u0015\u0019Gn\\2l!\t9C&D\u0001)\u0015\tI#&\u0001\u0003uS6,'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012Qa\u00117pG.\fa\u0001P5oSRtDc\u0001\u00192eA\u0011a\u0004\u0001\u0005\u0006C\r\u0001\rA\t\u0005\u0006K\r\u0001\rA\n\u0015\u0003\u0007Q\u0002\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\r%t'.Z2u\u0015\u0005I\u0014a\u00026bW\u0006\u0014H/Y\u0005\u0003wY\u0012a!\u00138kK\u000e$\u0018A\u0002:b]\u0012|W.F\u0001?!\ty$)D\u0001A\u0015\t\t%&\u0001\u0005tK\u000e,(/\u001b;z\u0013\t\u0019\u0005I\u0001\u0007TK\u000e,(/\u001a*b]\u0012|W.A\u0004sC:$w.\u001c\u0011\u0002\u0013MLwM\u001c+pW\u0016tGCA$S!\tAuJ\u0004\u0002J\u001bB\u0011!*G\u0007\u0002\u0017*\u0011A*F\u0001\u0007yI|w\u000e\u001e \n\u00059K\u0012A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!AT\r\t\u000bM3\u0001\u0019A$\u0002\u000bQ|7.\u001a8\u0002%\u0015DHO]1diNKwM\\3e)>\\WM\u001c\u000b\u0003-f\u00032\u0001G,H\u0013\tA\u0016D\u0001\u0004PaRLwN\u001c\u0005\u0006'\u001e\u0001\raR\u0001\u000eO\u0016tWM]1uKR{7.\u001a8\u0016\u0003\u001d\u000b1cZ3oKJ\fG/Z*jO:,G\rV8lK:\f1cY8na\u0006\u0014XmU5h]\u0016$Gk\\6f]N$2a\u00182e!\tA\u0002-\u0003\u0002b3\t9!i\\8mK\u0006t\u0007\"B2\u000b\u0001\u00049\u0015A\u0002;pW\u0016t\u0017\tC\u0003f\u0015\u0001\u0007q)\u0001\u0004u_.,gNQ\u0001\bSN,\u0015/^1m)\ry\u0006N\u001b\u0005\u0006S.\u0001\raR\u0001\u0002C\")1n\u0003a\u0001\u000f\u0006\t!\r")
public class DefaultCSRFTokenSigner
implements CSRFTokenSigner {
    private final CookieSigner signer;
    private final Clock clock;
    private final SecureRandom random;

    private SecureRandom random() {
        return this.random;
    }

    @Override
    public String signToken(String token) {
        long nonce = this.clock.millis();
        String joined = nonce + "-" + token;
        return this.signer.sign(joined) + "-" + joined;
    }

    @Override
    public Option<String> extractSignedToken(String token) {
        String raw2;
        String nonce;
        String signature;
        Object object;
        String[] stringArray = token.split("-", 3);
        if (stringArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) == 0 && this.isEqual(signature = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0), this.signer.sign((nonce = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1)) + "-" + (raw2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2))))) {
            return new Some((Object)raw2);
        }
        return None$.MODULE$;
    }

    @Override
    public String generateToken() {
        byte[] bytes = new byte[12];
        this.random().nextBytes(bytes);
        return Codecs$.MODULE$.toHexString(bytes);
    }

    @Override
    public String generateSignedToken() {
        return this.signToken(this.generateToken());
    }

    @Override
    public boolean compareSignedTokens(String tokenA, String tokenB) {
        return BoxesRunTime.unboxToBoolean((Object)this.extractSignedToken(tokenA).flatMap((Function1 & Serializable)rawA -> this.extractSignedToken(tokenB).map((Function1 & Serializable)rawB -> BoxesRunTime.boxToBoolean((boolean)this.isEqual(rawA, rawB)))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    private boolean isEqual(String a, String b) {
        return MessageDigest.isEqual(a.getBytes(StandardCharsets.UTF_8), b.getBytes(StandardCharsets.UTF_8));
    }

    @Inject
    public DefaultCSRFTokenSigner(CookieSigner signer, Clock clock) {
        this.signer = signer;
        this.clock = clock;
        this.random = new SecureRandom();
        this.random().nextBytes(new byte[55]);
    }
}

