/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.PrematureJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.jackson.io.JacksonDeserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.security.SignatureException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Clock;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.MarkerContexts$SecurityMarkerContext$;
import play.api.Mode;
import play.api.http.JWTConfiguration;
import play.api.http.SecretConfiguration;
import play.api.mvc.CookieDataCodec;
import play.api.mvc.JWTCookieDataCodec$;
import play.api.mvc.JWTCookieDataCodec$JWTIDGenerator$;
import play.libs.Scala;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055fa\u0002\u0013&!\u0003\r\t\u0001\f\u0005\u0006o\u0001!\t\u0001\u000f\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0015\u0011\u0005A\"\u0001D\u0011\u0015Q\u0005A\"\u0001L\u0011!y\u0005\u0001#b\u0001\n\u0013\u0001\u0006bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\t\t\u000b\u0001C\t\u0003GCa!\u001b\u0001\u0005\u0012\u0005-v!B*&\u0011\u0003!f!\u0002\u0013&\u0011\u0003)\u0006\"\u0002,\f\t\u00039\u0006b\u0002-\f\u0005\u0004%I!\u0017\u0005\u0007M.\u0001\u000b\u0011\u0002.\u0007\u000b\u001d\\\u0001!\u000b5\t\u0011\t{!\u0011!Q\u0001\n\u0011C\u0001BS\b\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\tS>\u0011\t\u0011)A\u0005U\")ak\u0004C\u0001e\"9\u0001p\u0004b\u0001\n\u0013I\bBB?\u0010A\u0003%!\u0010C\u0005\u0002\u0018=\u0011\r\u0011\"\u0003\u0002\u001a!A\u0011\u0011E\b!\u0002\u0013\tY\u0002C\u0005\u0002$=\u0011\r\u0011\"\u0003\u0002&!A\u0011qG\b!\u0002\u0013\t9\u0003C\u0005\u0002:=\u0011\r\u0011\"\u0003\u0002<!A\u00111I\b!\u0002\u0013\ti\u0004C\u0004\u0002F=!\t!a\u0012\t\u000f\u0005%t\u0002\"\u0001\u0002l\u001dA\u0011\u0011O\u0006\t\u0002%\n\u0019H\u0002\u0005\u0002v-A\t!KA<\u0011\u00191v\u0004\"\u0001\u0002z!I\u00111P\u0010C\u0002\u0013%\u0011Q\u0010\u0005\t\u0003\u0017{\u0002\u0015!\u0003\u0002\u0000!9\u0011QR\u0010\u0005\u0002\u0005=%A\u0005&X)\u000e{wn[5f\t\u0006$\u0018mQ8eK\u000eT!AJ\u0014\u0002\u0007548M\u0003\u0002)S\u0005\u0019\u0011\r]5\u000b\u0003)\nA\u0001\u001d7bs\u000e\u00011c\u0001\u0001.gA\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t1\u0011I\\=SK\u001a\u0004\"\u0001N\u001b\u000e\u0003\u0015J!AN\u0013\u0003\u001f\r{wn[5f\t\u0006$\u0018mQ8eK\u000e\fa\u0001J5oSR$C#A\u001d\u0011\u00059R\u0014BA\u001e0\u0005\u0011)f.\u001b;\u0002\r1|wmZ3s+\u0005q\u0004CA A\u001b\u00059\u0013BA!(\u0005\u0019aunZ4fe\u0006\u00192/Z2sKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tA\t\u0005\u0002F\u00116\taI\u0003\u0002HO\u0005!\u0001\u000e\u001e;q\u0013\tIeIA\nTK\u000e\u0014X\r^\"p]\u001aLw-\u001e:bi&|g.\u0001\tkoR\u001cuN\u001c4jOV\u0014\u0018\r^5p]V\tA\n\u0005\u0002F\u001b&\u0011aJ\u0012\u0002\u0011\u0015^#6i\u001c8gS\u001e,(/\u0019;j_:\f\u0011BZ8s[\u0006$H/\u001a:\u0016\u0003E\u0003\"AU\b\u000f\u0005QR\u0011A\u0005&X)\u000e{wn[5f\t\u0006$\u0018mQ8eK\u000e\u0004\"\u0001N\u0006\u0014\u0005-i\u0013A\u0002\u001fj]&$h\bF\u0001U\u00031y'M[3di6\u000b\u0007\u000f]3s+\u0005Q\u0006CA.e\u001b\u0005a&BA/_\u0003!!\u0017\r^1cS:$'BA0a\u0003\u001dQ\u0017mY6t_:T!!\u00192\u0002\u0013\u0019\f7\u000f^3sq6d'\"A2\u0002\u0007\r|W.\u0003\u0002f9\naqJ\u00196fGRl\u0015\r\u001d9fe\u0006iqN\u00196fGRl\u0015\r\u001d9fe\u0002\u0012ABS,U\r>\u0014X.\u0019;uKJ\u001c\"aD\u0017\u0002\u000b\rdwnY6\u0011\u0005-\u0004X\"\u00017\u000b\u00055t\u0017\u0001\u0002;j[\u0016T\u0011a\\\u0001\u0005U\u00064\u0018-\u0003\u0002rY\n)1\t\\8dWR!1/\u001e<x!\t!x\"D\u0001\f\u0011\u0015\u00115\u00031\u0001E\u0011\u0015Q5\u00031\u0001M\u0011\u0015I7\u00031\u0001k\u0003!Qw\u000f^\"m_\u000e\\W#\u0001>\u0013\tmt\u0018\u0011\u0002\u0004\u0005yV\u0001!P\u0001\u0007=e\u00164\u0017N\\3nK:$h(A\u0005koR\u001cEn\\2lAA\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002]\u0006!A.\u00198h\u0013\u0011\t9!!\u0001\u0003\r=\u0013'.Z2u!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\tAB[:p]^,'\r^8lK:T!!a\u0005\u0002\u0005%|\u0017bA9\u0002\u000e\u0005\u00112/[4oCR,(/Z!mO>\u0014\u0018\u000e\u001e5n+\t\tY\u0002\u0005\u0003\u0002\f\u0005u\u0011\u0002BA\u0010\u0003\u001b\u0011!cU5h]\u0006$XO]3BY\u001e|'/\u001b;i[\u0006\u00192/[4oCR,(/Z!mO>\u0014\u0018\u000e\u001e5nA\u0005I1/Z2sKR\\U-_\u000b\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0004def\u0004Ho\u001c\u0006\u0003\u0003c\tQA[1wCbLA!!\u000e\u0002,\tI1+Z2sKR\\U-_\u0001\u000bg\u0016\u001c'/\u001a;LKf\u0004\u0013!\u00036xiB\u000b'o]3s+\t\ti\u0004\u0005\u0003\u0002\f\u0005}\u0012\u0002BA!\u0003\u001b\u0011\u0011BS<u!\u0006\u00148/\u001a:\u0002\u0015)<H\u000fU1sg\u0016\u0014\b%A\u0003qCJ\u001cX\r\u0006\u0003\u0002J\u0005\u0015\u0004cBA&\u00033\ny&\f\b\u0005\u0003\u001b\n)\u0006E\u0002\u0002P=j!!!\u0015\u000b\u0007\u0005M3&\u0001\u0004=e>|GOP\u0005\u0004\u0003/z\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\\\u0005u#aA'ba*\u0019\u0011qK\u0018\u0011\t\u0005-\u0013\u0011M\u0005\u0005\u0003G\niF\u0001\u0004TiJLgn\u001a\u0005\b\u0003Ob\u0002\u0019AA0\u00035)gnY8eK\u0012\u001cFO]5oO\u00061am\u001c:nCR$B!a\u0018\u0002n!9\u0011qN\u000fA\u0002\u0005%\u0013AB2mC&l7/\u0001\bK/RKEiR3oKJ\fGo\u001c:\u0011\u0005Q|\"A\u0004&X)&#u)\u001a8fe\u0006$xN]\n\u0003?5\"\"!a\u001d\u0002\u0005M\u0014XCAA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC]\u0006A1/Z2ve&$\u00180\u0003\u0003\u0002\n\u0006\r%\u0001D*fGV\u0014XMU1oI>l\u0017aA:sA\u0005Qq-\u001a8fe\u0006$X-\u00133\u0015\u0005\u0005}\u0013AB3oG>$W\r\u0006\u0003\u0002`\u0005U\u0005bBAL\r\u0001\u0007\u0011\u0011T\u0001\u0005I\u0006$\u0018\r\u0005\u0005\u0002L\u0005e\u0013qLA0\u0003\u0019!WmY8eKR!\u0011\u0011TAP\u0011\u001d\t9g\u0002a\u0001\u0003?\n\u0001\"\u001e8jcV,\u0017\n\u001a\u000b\u0003\u0003K\u0003RALAT\u0003?J1!!+0\u0005\u0019y\u0005\u000f^5p]V\t!\u000e")
public interface JWTCookieDataCodec
extends CookieDataCodec {
    public void play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger var1);

    public Logger play$api$mvc$JWTCookieDataCodec$$logger();

    public SecretConfiguration secretConfiguration();

    public JWTConfiguration jwtConfiguration();

    public static /* synthetic */ JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter$(JWTCookieDataCodec $this) {
        return $this.play$api$mvc$JWTCookieDataCodec$$formatter();
    }

    default public JWTFormatter play$api$mvc$JWTCookieDataCodec$$formatter() {
        return new JWTFormatter(this.secretConfiguration(), this.jwtConfiguration(), this.clock());
    }

    public static /* synthetic */ String encode$(JWTCookieDataCodec $this, scala.collection.immutable.Map data) {
        return $this.encode((scala.collection.immutable.Map<String, String>)data);
    }

    @Override
    default public String encode(scala.collection.immutable.Map<String, String> data) {
        scala.collection.immutable.Map dataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.jwtConfiguration().dataClaim()), (Object)Jwts.claims(Scala.asJava(data)))}));
        return this.play$api$mvc$JWTCookieDataCodec$$formatter().format((scala.collection.immutable.Map<String, Object>)dataMap);
    }

    public static /* synthetic */ scala.collection.immutable.Map decode$(JWTCookieDataCodec $this, String encodedString) {
        return $this.decode(encodedString);
    }

    @Override
    default public scala.collection.immutable.Map<String, String> decode(String encodedString) {
        scala.collection.immutable.Map map2;
        try {
            scala.collection.immutable.Map<String, Object> claimMap = this.play$api$mvc$JWTCookieDataCodec$$formatter().parse(encodedString);
            Map data = (Map)claimMap.apply((Object)this.jwtConfiguration().dataClaim());
            map2 = CollectionConverters$.MODULE$.MapHasAsScala(data).asScala().view().mapValues((Function1 & Serializable)v -> v.toString()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (IllegalStateException illegalStateException) {
            this.play$api$mvc$JWTCookieDataCodec$$logger().error((Function0<String>)(Function0 & Serializable)() -> illegalStateException.getMessage(), MarkerContext$.MODULE$.NoMarker());
            map2 = Predef$.MODULE$.Map().empty();
        }
        catch (PrematureJwtException prematureJwtException) {
            String id = prematureJwtException.getClaims().getId();
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> "decode: premature JWT found! id = " + id + ", message = " + prematureJwtException.getMessage(), MarkerContexts$SecurityMarkerContext$.MODULE$);
            map2 = Predef$.MODULE$.Map().empty();
        }
        catch (ExpiredJwtException expiredJwtException) {
            String id = expiredJwtException.getClaims().getId();
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> "decode: expired JWT found! id = " + id + ", message = " + expiredJwtException.getMessage(), MarkerContexts$SecurityMarkerContext$.MODULE$);
            map2 = Predef$.MODULE$.Map().empty();
        }
        catch (SignatureException signatureException) {
            this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> "decode: cookie has invalid signature! message = " + signatureException.getMessage(), MarkerContexts$SecurityMarkerContext$.MODULE$);
            Logger devLogger = this.play$api$mvc$JWTCookieDataCodec$$logger().forMode((Seq<Mode>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Mode[]{Mode.Dev$.MODULE$}));
            devLogger.info((Function0<String>)(Function0 & Serializable)() -> "The JWT signature in the cookie does not match the locally computed signature with the server. This usually indicates the browser has a leftover cookie from another Play application, so clearing cookies may resolve this error message.", MarkerContext$.MODULE$.NoMarker());
            map2 = Predef$.MODULE$.Map().empty();
        }
        catch (Throwable throwable) {
            if (NonFatal$.MODULE$.apply(throwable)) {
                this.play$api$mvc$JWTCookieDataCodec$$logger().warn((Function0<String>)(Function0 & Serializable)() -> "decode: could not decode JWT: " + throwable.getMessage(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable, MarkerContexts$SecurityMarkerContext$.MODULE$);
                map2 = Predef$.MODULE$.Map().empty();
            }
            throw throwable;
        }
        return map2;
    }

    public static /* synthetic */ Option uniqueId$(JWTCookieDataCodec $this) {
        return $this.uniqueId();
    }

    default public Option<String> uniqueId() {
        return new Some((Object)JWTCookieDataCodec$JWTIDGenerator$.MODULE$.generateId());
    }

    public static /* synthetic */ Clock clock$(JWTCookieDataCodec $this) {
        return $this.clock();
    }

    default public Clock clock() {
        return Clock.systemUTC();
    }

    public static void $init$(JWTCookieDataCodec $this) {
        $this.play$api$mvc$JWTCookieDataCodec$_setter_$play$api$mvc$JWTCookieDataCodec$$logger_$eq(Logger$.MODULE$.apply($this.getClass()));
    }

    public static class JWTFormatter {
        private final JWTConfiguration jwtConfiguration;
        public final Clock play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock;
        private final io.jsonwebtoken.Clock jwtClock;
        private final SignatureAlgorithm signatureAlgorithm;
        private final SecretKey secretKey;
        private final JwtParser jwtParser;

        private io.jsonwebtoken.Clock jwtClock() {
            return this.jwtClock;
        }

        private SignatureAlgorithm signatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        private SecretKey secretKey() {
            return this.secretKey;
        }

        private JwtParser jwtParser() {
            return this.jwtParser;
        }

        public scala.collection.immutable.Map<String, Object> parse(String encodedString) {
            String headerAlgorithm;
            Jws jws;
            try {
                jws = this.jwtParser().parseClaimsJws(encodedString);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                jws = (Jws)JwtParser.class.getDeclaredMethod("parseClaimsJws", CharSequence.class).invoke((Object)this.jwtParser(), encodedString);
            }
            Jws jws2 = jws;
            String string = headerAlgorithm = ((JwsHeader)jws2.getHeader()).getAlgorithm();
            String string2 = this.jwtConfiguration.signatureAlgorithm();
            if (string == null ? string2 != null : !string.equals(string2)) {
                String id = ((Claims)jws2.getBody()).getId();
                String msg = "Invalid header algorithm " + headerAlgorithm + " in JWT " + id;
                throw new IllegalStateException(msg);
            }
            return CollectionConverters$.MODULE$.MapHasAsScala((Map)jws2.getBody()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public String format(scala.collection.immutable.Map<String, Object> claims) {
            Object object;
            Object object2;
            JwtBuilder builder = Jwts.builder().serializeToJsonWith((Serializer)new JacksonSerializer(JWTCookieDataCodec$.MODULE$.play$api$mvc$JWTCookieDataCodec$$objectMapper()));
            Date now = this.jwtClock().now();
            claims.foreach((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Object v = tuple2._2();
                    return builder.claim(k, v);
                }
                throw new MatchError((Object)tuple2);
            });
            this.jwtConfiguration.expiresAfter().map((Function1 & Serializable)duration -> {
                Date expirationDate = new Date(now.getTime() + duration.toMillis());
                return builder.setExpiration(expirationDate);
            });
            try {
                object2 = builder.setNotBefore(now);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object2 = JwtBuilder.class.getDeclaredMethod("notBefore", Date.class).invoke((Object)builder, now);
            }
            try {
                object = builder.setIssuedAt(now);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                object = JwtBuilder.class.getDeclaredMethod("issuedAt", Date.class).invoke((Object)builder, now);
            }
            return builder.signWith((Key)this.secretKey(), this.signatureAlgorithm()).compact();
        }

        public JWTFormatter(SecretConfiguration secretConfiguration, JWTConfiguration jwtConfiguration, Clock clock) {
            this.jwtConfiguration = jwtConfiguration;
            this.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock = clock;
            this.jwtClock = new io.jsonwebtoken.Clock(this){
                private final /* synthetic */ JWTFormatter $outer;

                public Date now() {
                    return Date.from(this.$outer.play$api$mvc$JWTCookieDataCodec$JWTFormatter$$clock.instant());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.signatureAlgorithm = SignatureAlgorithm.forName((String)jwtConfiguration.signatureAlgorithm());
            this.secretKey = new SecretKeySpec(secretConfiguration.secret().getBytes(StandardCharsets.UTF_8), this.signatureAlgorithm().getJcaName());
            this.jwtParser = ((JwtParserBuilder)Classes.newInstance((String)"io.jsonwebtoken.impl.DefaultJwtParserBuilder")).setClock(this.jwtClock()).setSigningKey((Key)this.secretKey()).setAllowedClockSkewSeconds(jwtConfiguration.clockSkew().toSeconds()).deserializeJsonWith((Deserializer)new JacksonDeserializer(JWTCookieDataCodec$.MODULE$.play$api$mvc$JWTCookieDataCodec$$objectMapper())).build();
        }
    }
}

