/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.pekko.util.ByteString;
import play.api.mvc.Results$;
import play.core.j.JavaHelpers;
import play.http.HttpEntity;
import play.mvc.Call;
import play.mvc.FileMimeTypes;
import play.mvc.Result;
import play.mvc.StaticFileMimeTypes;
import play.mvc.StatusHeader;
import play.twirl.api.Content;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class Results {
    private static final String UTF8 = "utf-8";

    public static Map<String, String> contentDispositionHeader(boolean bl, Optional<String> optional) {
        return CollectionConverters.asJava(play.api.mvc.Results.contentDispositionHeader(bl, (Option<String>)OptionConverters.toScala(optional)));
    }

    public static StatusHeader status(int n) {
        return new StatusHeader(n);
    }

    public static Result status(int n, Content content) {
        return Results.status(n, content, UTF8);
    }

    public static Result status(int n, Content content, String string) {
        if (content == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendEntity(HttpEntity.fromContent(content, string));
    }

    public static Result status(int n, String string) {
        return Results.status(n, string, UTF8);
    }

    public static Result status(int n, String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendEntity(HttpEntity.fromString(string, string2));
    }

    public static Result status(int n, JsonNode jsonNode) {
        return Results.status(n, jsonNode, JsonEncoding.UTF8);
    }

    public static Result status(int n, JsonNode jsonNode, JsonEncoding jsonEncoding) {
        if (jsonNode == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendJson(jsonNode, jsonEncoding);
    }

    public static Result status(int n, byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendBytes(byArray);
    }

    public static Result status(int n, ByteString byteString) {
        if (byteString == null) {
            throw new NullPointerException("Null content");
        }
        return Results.status(n).sendByteString(byteString);
    }

    public static Result status(int n, InputStream inputStream) {
        return Results.status(n).sendInputStream(inputStream);
    }

    public static Result status(int n, InputStream inputStream, long l) {
        return Results.status(n).sendInputStream(inputStream, l);
    }

    public static Result status(int n, File file) {
        return Results.status(n, file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result status(int n, File file, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendFile(file, fileMimeTypes);
    }

    public static Result status(int n, File file, boolean bl) {
        return Results.status(n, file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result status(int n, File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendFile(file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result status(int n, File file, String string) {
        return Results.status(n, file, Optional.ofNullable(string));
    }

    public static Result status(int n, File file, Optional<String> optional) {
        return Results.status(n, file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result status(int n, File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.status(n, file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result status(int n, File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendFile(file, optional, fileMimeTypes);
    }

    public static Result status(int n, File file, boolean bl, Optional<String> optional) {
        return Results.status(n).sendFile(file, bl, optional);
    }

    public static Result status(int n, File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendFile(file, bl, optional, fileMimeTypes);
    }

    public static Result status(int n, Path path) {
        return Results.status(n, path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result status(int n, Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendPath(path, fileMimeTypes);
    }

    public static Result status(int n, Path path, boolean bl) {
        return Results.status(n, path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result status(int n, Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendPath(path, bl, fileMimeTypes);
    }

    public static Result status(int n, Path path, Optional<String> optional) {
        return Results.status(n, path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result status(int n, Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendPath(path, optional, fileMimeTypes);
    }

    public static Result status(int n, Path path, boolean bl, Optional<String> optional) {
        return Results.status(n).sendPath(path, bl, optional);
    }

    public static Result status(int n, Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(n).sendPath(path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader noContent() {
        return new StatusHeader(204);
    }

    public static StatusHeader ok() {
        return new StatusHeader(200);
    }

    public static Result ok(Content content) {
        return Results.status(200, content);
    }

    public static Result ok(Content content, String string) {
        return Results.status(200, content, string);
    }

    public static Result ok(String string) {
        return Results.status(200, string);
    }

    public static Result ok(String string, String string2) {
        return Results.status(200, string, string2);
    }

    public static Result ok(JsonNode jsonNode) {
        return Results.status(200, jsonNode);
    }

    public static Result ok(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(200, jsonNode, jsonEncoding);
    }

    public static Result ok(byte[] byArray) {
        return Results.status(200, byArray);
    }

    public static Result ok(InputStream inputStream) {
        return Results.status(200, inputStream);
    }

    public static Result ok(InputStream inputStream, long l) {
        return Results.status(200, inputStream, l);
    }

    public static Result ok(File file) {
        return Results.ok(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ok(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(200, file, fileMimeTypes);
    }

    public static Result ok(File file, boolean bl) {
        return Results.ok(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ok(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(200, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result ok(File file, String string) {
        return Results.ok(file, Optional.ofNullable(string));
    }

    public static Result ok(File file, Optional<String> optional) {
        return Results.ok(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result ok(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.ok(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result ok(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(200, file, optional, fileMimeTypes);
    }

    public static Result ok(File file, boolean bl, Optional<String> optional) {
        return Results.status(200, file, bl, optional);
    }

    public static Result ok(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(200, file, bl, optional, fileMimeTypes);
    }

    public static Result ok(Path path) {
        return Results.ok(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ok(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(200, path, fileMimeTypes);
    }

    public static Result ok(Path path, boolean bl) {
        return Results.ok(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ok(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(200, path, bl, fileMimeTypes);
    }

    public static Result ok(Path path, Optional<String> optional) {
        return Results.ok(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result ok(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(200, path, optional, fileMimeTypes);
    }

    public static Result ok(Path path, boolean bl, Optional<String> optional) {
        return Results.status(200, path, bl, optional);
    }

    public static Result ok(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(200, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader created() {
        return new StatusHeader(201);
    }

    public static Result created(Content content) {
        return Results.status(201, content);
    }

    public static Result created(Content content, String string) {
        return Results.status(201, content, string);
    }

    public static Result created(String string) {
        return Results.status(201, string);
    }

    public static Result created(String string, String string2) {
        return Results.status(201, string, string2);
    }

    public static Result created(JsonNode jsonNode) {
        return Results.status(201, jsonNode);
    }

    public static Result created(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(201, jsonNode, jsonEncoding);
    }

    public static Result created(byte[] byArray) {
        return Results.status(201, byArray);
    }

    public static Result created(InputStream inputStream) {
        return Results.status(201, inputStream);
    }

    public static Result created(InputStream inputStream, long l) {
        return Results.status(201, inputStream, l);
    }

    public static Result created(File file) {
        return Results.created(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result created(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(201, file, fileMimeTypes);
    }

    public static Result created(File file, boolean bl) {
        return Results.created(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result created(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(201, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result created(File file, String string) {
        return Results.created(file, Optional.ofNullable(string));
    }

    public static Result created(File file, Optional<String> optional) {
        return Results.created(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result created(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.created(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result created(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(201, file, optional, fileMimeTypes);
    }

    public static Result created(File file, boolean bl, Optional<String> optional) {
        return Results.status(201, file, bl, optional);
    }

    public static Result created(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(201, file, bl, optional, fileMimeTypes);
    }

    public static Result created(Path path) {
        return Results.created(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result created(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(201, path, fileMimeTypes);
    }

    public static Result created(Path path, boolean bl) {
        return Results.created(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result created(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(201, path, bl, fileMimeTypes);
    }

    public static Result created(Path path, Optional<String> optional) {
        return Results.created(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result created(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(201, path, optional, fileMimeTypes);
    }

    public static Result created(Path path, boolean bl, Optional<String> optional) {
        return Results.status(201, path, bl, optional);
    }

    public static Result created(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(201, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader badRequest() {
        return new StatusHeader(400);
    }

    public static Result badRequest(Content content) {
        return Results.status(400, content);
    }

    public static Result badRequest(Content content, String string) {
        return Results.status(400, content, string);
    }

    public static Result badRequest(String string) {
        return Results.status(400, string);
    }

    public static Result badRequest(String string, String string2) {
        return Results.status(400, string, string2);
    }

    public static Result badRequest(JsonNode jsonNode) {
        return Results.status(400, jsonNode);
    }

    public static Result badRequest(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(400, jsonNode, jsonEncoding);
    }

    public static Result badRequest(byte[] byArray) {
        return Results.status(400, byArray);
    }

    public static Result badRequest(InputStream inputStream) {
        return Results.status(400, inputStream);
    }

    public static Result badRequest(InputStream inputStream, long l) {
        return Results.status(400, inputStream, l);
    }

    public static Result badRequest(File file) {
        return Results.badRequest(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result badRequest(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(400, file, fileMimeTypes);
    }

    public static Result badRequest(File file, boolean bl) {
        return Results.badRequest(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result badRequest(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(400, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result badRequest(File file, String string) {
        return Results.badRequest(file, Optional.ofNullable(string));
    }

    public static Result badRequest(File file, Optional<String> optional) {
        return Results.badRequest(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result badRequest(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.badRequest(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result badRequest(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(400, file, optional, fileMimeTypes);
    }

    public static Result badRequest(File file, boolean bl, Optional<String> optional) {
        return Results.status(400, file, bl, optional);
    }

    public static Result badRequest(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(400, file, bl, optional, fileMimeTypes);
    }

    public static Result badRequest(Path path) {
        return Results.badRequest(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result badRequest(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(400, path, fileMimeTypes);
    }

    public static Result badRequest(Path path, boolean bl) {
        return Results.badRequest(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result badRequest(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(400, path, bl, fileMimeTypes);
    }

    public static Result badRequest(Path path, Optional<String> optional) {
        return Results.badRequest(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result badRequest(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(400, path, optional, fileMimeTypes);
    }

    public static Result badRequest(Path path, boolean bl, Optional<String> optional) {
        return Results.status(400, path, bl, optional);
    }

    public static Result badRequest(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(400, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader unauthorized() {
        return new StatusHeader(401);
    }

    public static Result unauthorized(Content content) {
        return Results.status(401, content);
    }

    public static Result unauthorized(Content content, String string) {
        return Results.status(401, content, string);
    }

    public static Result unauthorized(String string) {
        return Results.status(401, string);
    }

    public static Result unauthorized(String string, String string2) {
        return Results.status(401, string, string2);
    }

    public static Result unauthorized(JsonNode jsonNode) {
        return Results.status(401, jsonNode);
    }

    public static Result unauthorized(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(401, jsonNode, jsonEncoding);
    }

    public static Result unauthorized(byte[] byArray) {
        return Results.status(401, byArray);
    }

    public static Result unauthorized(InputStream inputStream) {
        return Results.status(401, inputStream);
    }

    public static Result unauthorized(InputStream inputStream, long l) {
        return Results.status(401, inputStream, l);
    }

    public static Result unauthorized(File file) {
        return Results.unauthorized(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unauthorized(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(401, file, fileMimeTypes);
    }

    public static Result unauthorized(File file, boolean bl) {
        return Results.unauthorized(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unauthorized(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(401, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result unauthorized(File file, String string) {
        return Results.unauthorized(file, Optional.ofNullable(string));
    }

    public static Result unauthorized(File file, Optional<String> optional) {
        return Results.unauthorized(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result unauthorized(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.unauthorized(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result unauthorized(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(401, file, optional, fileMimeTypes);
    }

    public static Result unauthorized(File file, boolean bl, Optional<String> optional) {
        return Results.status(401, file, bl, optional);
    }

    public static Result unauthorized(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(401, file, bl, optional, fileMimeTypes);
    }

    public static Result unauthorized(Path path) {
        return Results.unauthorized(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unauthorized(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(401, path, fileMimeTypes);
    }

    public static Result unauthorized(Path path, boolean bl) {
        return Results.unauthorized(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unauthorized(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(401, path, bl, fileMimeTypes);
    }

    public static Result unauthorized(Path path, Optional<String> optional) {
        return Results.unauthorized(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unauthorized(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(401, path, optional, fileMimeTypes);
    }

    public static Result unauthorized(Path path, boolean bl, Optional<String> optional) {
        return Results.status(401, path, bl, optional);
    }

    public static Result unauthorized(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(401, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader paymentRequired() {
        return new StatusHeader(402);
    }

    public static Result paymentRequired(Content content) {
        return Results.status(402, content);
    }

    public static Result paymentRequired(Content content, String string) {
        return Results.status(402, content, string);
    }

    public static Result paymentRequired(String string) {
        return Results.status(402, string);
    }

    public static Result paymentRequired(String string, String string2) {
        return Results.status(402, string, string2);
    }

    public static Result paymentRequired(JsonNode jsonNode) {
        return Results.status(402, jsonNode);
    }

    public static Result paymentRequired(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(402, jsonNode, jsonEncoding);
    }

    public static Result paymentRequired(byte[] byArray) {
        return Results.status(402, byArray);
    }

    public static Result paymentRequired(InputStream inputStream) {
        return Results.status(402, inputStream);
    }

    public static Result paymentRequired(InputStream inputStream, long l) {
        return Results.status(402, inputStream, l);
    }

    public static Result paymentRequired(File file) {
        return Results.paymentRequired(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result paymentRequired(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(402, file, fileMimeTypes);
    }

    public static Result paymentRequired(File file, boolean bl) {
        return Results.paymentRequired(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result paymentRequired(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(402, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result paymentRequired(File file, String string) {
        return Results.paymentRequired(file, Optional.ofNullable(string));
    }

    public static Result paymentRequired(File file, Optional<String> optional) {
        return Results.paymentRequired(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result paymentRequired(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.paymentRequired(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result paymentRequired(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(402, file, optional, fileMimeTypes);
    }

    public static Result paymentRequired(File file, boolean bl, Optional<String> optional) {
        return Results.status(402, file, bl, optional);
    }

    public static Result paymentRequired(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(402, file, bl, optional, fileMimeTypes);
    }

    public static Result paymentRequired(Path path) {
        return Results.paymentRequired(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result paymentRequired(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(402, path, fileMimeTypes);
    }

    public static Result paymentRequired(Path path, boolean bl) {
        return Results.paymentRequired(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result paymentRequired(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(402, path, bl, fileMimeTypes);
    }

    public static Result paymentRequired(Path path, Optional<String> optional) {
        return Results.paymentRequired(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result paymentRequired(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(402, path, optional, fileMimeTypes);
    }

    public static Result paymentRequired(Path path, boolean bl, Optional<String> optional) {
        return Results.status(402, path, bl, optional);
    }

    public static Result paymentRequired(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(402, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader forbidden() {
        return new StatusHeader(403);
    }

    public static Result forbidden(Content content) {
        return Results.status(403, content);
    }

    public static Result forbidden(Content content, String string) {
        return Results.status(403, content, string);
    }

    public static Result forbidden(String string) {
        return Results.status(403, string);
    }

    public static Result forbidden(String string, String string2) {
        return Results.status(403, string, string2);
    }

    public static Result forbidden(JsonNode jsonNode) {
        return Results.status(403, jsonNode);
    }

    public static Result forbidden(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(403, jsonNode, jsonEncoding);
    }

    public static Result forbidden(byte[] byArray) {
        return Results.status(403, byArray);
    }

    public static Result forbidden(InputStream inputStream) {
        return Results.status(403, inputStream);
    }

    public static Result forbidden(InputStream inputStream, long l) {
        return Results.status(403, inputStream, l);
    }

    public static Result forbidden(File file) {
        return Results.forbidden(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result forbidden(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(403, file, fileMimeTypes);
    }

    public static Result forbidden(File file, boolean bl) {
        return Results.forbidden(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result forbidden(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(403, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result forbidden(File file, String string) {
        return Results.forbidden(file, Optional.ofNullable(string));
    }

    public static Result forbidden(File file, Optional<String> optional) {
        return Results.forbidden(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result forbidden(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.forbidden(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result forbidden(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(403, file, optional, fileMimeTypes);
    }

    public static Result forbidden(File file, boolean bl, Optional<String> optional) {
        return Results.status(403, file, bl, optional);
    }

    public static Result forbidden(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(403, file, bl, optional, fileMimeTypes);
    }

    public static Result forbidden(Path path) {
        return Results.forbidden(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result forbidden(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(403, path, fileMimeTypes);
    }

    public static Result forbidden(Path path, boolean bl) {
        return Results.forbidden(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result forbidden(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(403, path, bl, fileMimeTypes);
    }

    public static Result forbidden(Path path, Optional<String> optional) {
        return Results.forbidden(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result forbidden(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(403, path, optional, fileMimeTypes);
    }

    public static Result forbidden(Path path, boolean bl, Optional<String> optional) {
        return Results.status(403, path, bl, optional);
    }

    public static Result forbidden(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(403, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader notFound() {
        return new StatusHeader(404);
    }

    public static Result notFound(Content content) {
        return Results.status(404, content);
    }

    public static Result notFound(Content content, String string) {
        return Results.status(404, content, string);
    }

    public static Result notFound(String string) {
        return Results.status(404, string);
    }

    public static Result notFound(String string, String string2) {
        return Results.status(404, string, string2);
    }

    public static Result notFound(JsonNode jsonNode) {
        return Results.status(404, jsonNode);
    }

    public static Result notFound(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(404, jsonNode, jsonEncoding);
    }

    public static Result notFound(byte[] byArray) {
        return Results.status(404, byArray);
    }

    public static Result notFound(InputStream inputStream) {
        return Results.status(404, inputStream);
    }

    public static Result notFound(InputStream inputStream, long l) {
        return Results.status(404, inputStream, l);
    }

    public static Result notFound(File file) {
        return Results.notFound(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notFound(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(404, file, fileMimeTypes);
    }

    public static Result notFound(File file, boolean bl) {
        return Results.notFound(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notFound(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(404, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result notFound(File file, String string) {
        return Results.notFound(file, Optional.ofNullable(string));
    }

    public static Result notFound(File file, Optional<String> optional) {
        return Results.notFound(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result notFound(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.notFound(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result notFound(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(404, file, optional, fileMimeTypes);
    }

    public static Result notFound(File file, boolean bl, Optional<String> optional) {
        return Results.status(404, file, bl, optional);
    }

    public static Result notFound(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(404, file, bl, optional, fileMimeTypes);
    }

    public static Result notFound(Path path) {
        return Results.notFound(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notFound(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(404, path, fileMimeTypes);
    }

    public static Result notFound(Path path, boolean bl) {
        return Results.notFound(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notFound(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(404, path, bl, fileMimeTypes);
    }

    public static Result notFound(Path path, Optional<String> optional) {
        return Results.notFound(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notFound(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(404, path, optional, fileMimeTypes);
    }

    public static Result notFound(Path path, boolean bl, Optional<String> optional) {
        return Results.status(404, path, bl, optional);
    }

    public static Result notFound(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(404, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader notAcceptable() {
        return new StatusHeader(406);
    }

    public static Result notAcceptable(Content content) {
        return Results.status(406, content);
    }

    public static Result notAcceptable(Content content, String string) {
        return Results.status(406, content, string);
    }

    public static Result notAcceptable(String string) {
        return Results.status(406, string);
    }

    public static Result notAcceptable(String string, String string2) {
        return Results.status(406, string, string2);
    }

    public static Result notAcceptable(JsonNode jsonNode) {
        return Results.status(406, jsonNode);
    }

    public static Result notAcceptable(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(406, jsonNode, jsonEncoding);
    }

    public static Result notAcceptable(byte[] byArray) {
        return Results.status(406, byArray);
    }

    public static Result notAcceptable(InputStream inputStream) {
        return Results.status(406, inputStream);
    }

    public static Result notAcceptable(InputStream inputStream, long l) {
        return Results.status(406, inputStream, l);
    }

    public static Result notAcceptable(File file) {
        return Results.notAcceptable(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notAcceptable(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(406, file, fileMimeTypes);
    }

    public static Result notAcceptable(File file, boolean bl) {
        return Results.notAcceptable(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notAcceptable(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(406, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result notAcceptable(File file, String string) {
        return Results.notAcceptable(file, Optional.ofNullable(string));
    }

    public static Result notAcceptable(File file, Optional<String> optional) {
        return Results.notAcceptable(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result notAcceptable(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.notAcceptable(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result notAcceptable(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(406, file, optional, fileMimeTypes);
    }

    public static Result notAcceptable(File file, boolean bl, Optional<String> optional) {
        return Results.status(406, file, bl, optional);
    }

    public static Result notAcceptable(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(406, file, bl, optional, fileMimeTypes);
    }

    public static Result notAcceptable(Path path) {
        return Results.notAcceptable(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notAcceptable(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(406, path, fileMimeTypes);
    }

    public static Result notAcceptable(Path path, boolean bl) {
        return Results.notAcceptable(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notAcceptable(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(406, path, bl, fileMimeTypes);
    }

    public static Result notAcceptable(Path path, Optional<String> optional) {
        return Results.notAcceptable(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result notAcceptable(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(406, path, optional, fileMimeTypes);
    }

    public static Result notAcceptable(Path path, boolean bl, Optional<String> optional) {
        return Results.status(406, path, bl, optional);
    }

    public static Result notAcceptable(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(406, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader unsupportedMediaType() {
        return new StatusHeader(415);
    }

    public static Result unsupportedMediaType(Content content) {
        return Results.status(415, content);
    }

    public static Result unsupportedMediaType(Content content, String string) {
        return Results.status(415, content, string);
    }

    public static Result unsupportedMediaType(String string) {
        return Results.status(415, string);
    }

    public static Result unsupportedMediaType(String string, String string2) {
        return Results.status(415, string, string2);
    }

    public static Result unsupportedMediaType(JsonNode jsonNode) {
        return Results.status(415, jsonNode);
    }

    public static Result unsupportedMediaType(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(415, jsonNode, jsonEncoding);
    }

    public static Result unsupportedMediaType(byte[] byArray) {
        return Results.status(415, byArray);
    }

    public static Result unsupportedMediaType(InputStream inputStream) {
        return Results.status(415, inputStream);
    }

    public static Result unsupportedMediaType(InputStream inputStream, long l) {
        return Results.status(415, inputStream, l);
    }

    public static Result unsupportedMediaType(File file) {
        return Results.unsupportedMediaType(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unsupportedMediaType(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(415, file, fileMimeTypes);
    }

    public static Result unsupportedMediaType(File file, boolean bl) {
        return Results.unsupportedMediaType(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unsupportedMediaType(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(415, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result unsupportedMediaType(File file, String string) {
        return Results.unsupportedMediaType(file, Optional.ofNullable(string));
    }

    public static Result unsupportedMediaType(File file, Optional<String> optional) {
        return Results.unsupportedMediaType(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result unsupportedMediaType(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.unsupportedMediaType(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result unsupportedMediaType(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(415, file, optional, fileMimeTypes);
    }

    public static Result unsupportedMediaType(File file, boolean bl, Optional<String> optional) {
        return Results.status(415, file, bl, optional);
    }

    public static Result unsupportedMediaType(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(415, file, bl, optional, fileMimeTypes);
    }

    public static Result unsupportedMediaType(Path path) {
        return Results.unsupportedMediaType(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unsupportedMediaType(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(415, path, fileMimeTypes);
    }

    public static Result unsupportedMediaType(Path path, boolean bl) {
        return Results.unsupportedMediaType(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unsupportedMediaType(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(415, path, bl, fileMimeTypes);
    }

    public static Result unsupportedMediaType(Path path, Optional<String> optional) {
        return Results.unsupportedMediaType(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result unsupportedMediaType(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(415, path, optional, fileMimeTypes);
    }

    public static Result unsupportedMediaType(Path path, boolean bl, Optional<String> optional) {
        return Results.status(415, path, bl, optional);
    }

    public static Result unsupportedMediaType(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(415, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader preconditionRequired() {
        return new StatusHeader(428);
    }

    public static Result preconditionRequired(Content content) {
        return Results.status(428, content);
    }

    public static Result preconditionRequired(Content content, String string) {
        return Results.status(428, content, string);
    }

    public static Result preconditionRequired(String string) {
        return Results.status(428, string);
    }

    public static Result preconditionRequired(String string, String string2) {
        return Results.status(428, string, string2);
    }

    public static Result preconditionRequired(JsonNode jsonNode) {
        return Results.status(428, jsonNode);
    }

    public static Result preconditionRequired(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(428, jsonNode, jsonEncoding);
    }

    public static Result preconditionRequired(byte[] byArray) {
        return Results.status(428, byArray);
    }

    public static Result preconditionRequired(InputStream inputStream) {
        return Results.status(428, inputStream);
    }

    public static Result preconditionRequired(InputStream inputStream, long l) {
        return Results.status(428, inputStream, l);
    }

    public static Result preconditionRequired(File file) {
        return Results.preconditionRequired(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result preconditionRequired(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(428, file, fileMimeTypes);
    }

    public static Result preconditionRequired(File file, boolean bl) {
        return Results.preconditionRequired(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result preconditionRequired(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(428, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result preconditionRequired(File file, String string) {
        return Results.preconditionRequired(file, Optional.ofNullable(string));
    }

    public static Result preconditionRequired(File file, Optional<String> optional) {
        return Results.preconditionRequired(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result preconditionRequired(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.preconditionRequired(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result preconditionRequired(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(428, file, optional, fileMimeTypes);
    }

    public static Result preconditionRequired(File file, boolean bl, Optional<String> optional) {
        return Results.status(428, file, bl, optional);
    }

    public static Result preconditionRequired(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(428, file, bl, optional, fileMimeTypes);
    }

    public static Result preconditionRequired(Path path) {
        return Results.preconditionRequired(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result preconditionRequired(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(428, path, fileMimeTypes);
    }

    public static Result preconditionRequired(Path path, boolean bl) {
        return Results.preconditionRequired(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result preconditionRequired(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(428, path, bl, fileMimeTypes);
    }

    public static Result preconditionRequired(Path path, Optional<String> optional) {
        return Results.preconditionRequired(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result preconditionRequired(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(428, path, optional, fileMimeTypes);
    }

    public static Result preconditionRequired(Path path, boolean bl, Optional<String> optional) {
        return Results.status(428, path, bl, optional);
    }

    public static Result preconditionRequired(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(428, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader tooManyRequests() {
        return new StatusHeader(429);
    }

    public static Result tooManyRequests(Content content) {
        return Results.status(429, content);
    }

    public static Result tooManyRequests(Content content, String string) {
        return Results.status(429, content, string);
    }

    public static Result tooManyRequests(String string) {
        return Results.status(429, string);
    }

    public static Result tooManyRequests(String string, String string2) {
        return Results.status(429, string, string2);
    }

    public static Result tooManyRequests(JsonNode jsonNode) {
        return Results.status(429, jsonNode);
    }

    public static Result tooManyRequests(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(429, jsonNode, jsonEncoding);
    }

    public static Result tooManyRequests(byte[] byArray) {
        return Results.status(429, byArray);
    }

    public static Result tooManyRequests(InputStream inputStream) {
        return Results.status(429, inputStream);
    }

    public static Result tooManyRequests(InputStream inputStream, long l) {
        return Results.status(429, inputStream, l);
    }

    public static Result tooManyRequests(File file) {
        return Results.tooManyRequests(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result tooManyRequests(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(429, file, fileMimeTypes);
    }

    public static Result tooManyRequests(File file, boolean bl) {
        return Results.tooManyRequests(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result tooManyRequests(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(429, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result tooManyRequests(File file, String string) {
        return Results.tooManyRequests(file, Optional.ofNullable(string));
    }

    public static Result tooManyRequests(File file, Optional<String> optional) {
        return Results.tooManyRequests(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result tooManyRequests(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.tooManyRequests(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result tooManyRequests(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(429, file, optional, fileMimeTypes);
    }

    public static Result tooManyRequests(File file, boolean bl, Optional<String> optional) {
        return Results.status(429, file, bl, optional);
    }

    public static Result tooManyRequests(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(429, file, bl, optional, fileMimeTypes);
    }

    public static Result tooManyRequests(Path path) {
        return Results.tooManyRequests(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result tooManyRequests(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(429, path, fileMimeTypes);
    }

    public static Result tooManyRequests(Path path, boolean bl) {
        return Results.tooManyRequests(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result tooManyRequests(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(429, path, bl, fileMimeTypes);
    }

    public static Result tooManyRequests(Path path, Optional<String> optional) {
        return Results.tooManyRequests(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result tooManyRequests(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(429, path, optional, fileMimeTypes);
    }

    public static Result tooManyRequests(Path path, boolean bl, Optional<String> optional) {
        return Results.status(429, path, bl, optional);
    }

    public static Result tooManyRequests(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(429, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader requestHeaderFieldsTooLarge() {
        return new StatusHeader(431);
    }

    public static Result requestHeaderFieldsTooLarge(Content content) {
        return Results.status(431, content);
    }

    public static Result requestHeaderFieldsTooLarge(Content content, String string) {
        return Results.status(431, content, string);
    }

    public static Result requestHeaderFieldsTooLarge(String string) {
        return Results.status(431, string);
    }

    public static Result requestHeaderFieldsTooLarge(String string, String string2) {
        return Results.status(431, string, string2);
    }

    public static Result requestHeaderFieldsTooLarge(JsonNode jsonNode) {
        return Results.status(431, jsonNode);
    }

    public static Result requestHeaderFieldsTooLarge(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(431, jsonNode, jsonEncoding);
    }

    public static Result requestHeaderFieldsTooLarge(byte[] byArray) {
        return Results.status(431, byArray);
    }

    public static Result requestHeaderFieldsTooLarge(InputStream inputStream) {
        return Results.status(431, inputStream);
    }

    public static Result requestHeaderFieldsTooLarge(InputStream inputStream, long l) {
        return Results.status(431, inputStream, l);
    }

    public static Result requestHeaderFieldsTooLarge(File file) {
        return Results.requestHeaderFieldsTooLarge(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result requestHeaderFieldsTooLarge(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(431, file, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(File file, boolean bl) {
        return Results.requestHeaderFieldsTooLarge(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result requestHeaderFieldsTooLarge(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(431, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result requestHeaderFieldsTooLarge(File file, String string) {
        return Results.requestHeaderFieldsTooLarge(file, Optional.ofNullable(string));
    }

    public static Result requestHeaderFieldsTooLarge(File file, Optional<String> optional) {
        return Results.requestHeaderFieldsTooLarge(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result requestHeaderFieldsTooLarge(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.requestHeaderFieldsTooLarge(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(431, file, optional, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(File file, boolean bl, Optional<String> optional) {
        return Results.status(431, file, bl, optional);
    }

    public static Result requestHeaderFieldsTooLarge(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(431, file, bl, optional, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(Path path) {
        return Results.requestHeaderFieldsTooLarge(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result requestHeaderFieldsTooLarge(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(431, path, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(Path path, boolean bl) {
        return Results.requestHeaderFieldsTooLarge(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result requestHeaderFieldsTooLarge(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(431, path, bl, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(Path path, Optional<String> optional) {
        return Results.requestHeaderFieldsTooLarge(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result requestHeaderFieldsTooLarge(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(431, path, optional, fileMimeTypes);
    }

    public static Result requestHeaderFieldsTooLarge(Path path, boolean bl, Optional<String> optional) {
        return Results.status(431, path, bl, optional);
    }

    public static Result requestHeaderFieldsTooLarge(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(431, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader internalServerError() {
        return new StatusHeader(500);
    }

    public static Result internalServerError(Content content) {
        return Results.status(500, content);
    }

    public static Result internalServerError(Content content, String string) {
        return Results.status(500, content, string);
    }

    public static Result internalServerError(String string) {
        return Results.status(500, string);
    }

    public static Result internalServerError(String string, String string2) {
        return Results.status(500, string, string2);
    }

    public static Result internalServerError(JsonNode jsonNode) {
        return Results.status(500, jsonNode);
    }

    public static Result internalServerError(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(500, jsonNode, jsonEncoding);
    }

    public static Result internalServerError(byte[] byArray) {
        return Results.status(500, byArray);
    }

    public static Result internalServerError(InputStream inputStream) {
        return Results.status(500, inputStream);
    }

    public static Result internalServerError(InputStream inputStream, long l) {
        return Results.status(500, inputStream, l);
    }

    public static Result internalServerError(File file) {
        return Results.internalServerError(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result internalServerError(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(500, file, fileMimeTypes);
    }

    public static Result internalServerError(File file, boolean bl) {
        return Results.internalServerError(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result internalServerError(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(500, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result internalServerError(File file, String string) {
        return Results.internalServerError(file, Optional.ofNullable(string));
    }

    public static Result internalServerError(File file, Optional<String> optional) {
        return Results.internalServerError(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result internalServerError(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.internalServerError(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result internalServerError(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(500, file, optional, fileMimeTypes);
    }

    public static Result internalServerError(File file, boolean bl, Optional<String> optional) {
        return Results.status(500, file, bl, optional);
    }

    public static Result internalServerError(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(500, file, bl, optional, fileMimeTypes);
    }

    public static Result internalServerError(Path path) {
        return Results.internalServerError(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result internalServerError(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(500, path, fileMimeTypes);
    }

    public static Result internalServerError(Path path, boolean bl) {
        return Results.internalServerError(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result internalServerError(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(500, path, bl, fileMimeTypes);
    }

    public static Result internalServerError(Path path, Optional<String> optional) {
        return Results.internalServerError(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result internalServerError(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(500, path, optional, fileMimeTypes);
    }

    public static Result internalServerError(Path path, boolean bl, Optional<String> optional) {
        return Results.status(500, path, bl, optional);
    }

    public static Result internalServerError(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(500, path, bl, optional, fileMimeTypes);
    }

    public static StatusHeader networkAuthenticationRequired() {
        return new StatusHeader(511);
    }

    public static Result networkAuthenticationRequired(Content content) {
        return Results.status(511, content);
    }

    public static Result networkAuthenticationRequired(Content content, String string) {
        return Results.status(511, content, string);
    }

    public static Result networkAuthenticationRequired(String string) {
        return Results.status(511, string);
    }

    public static Result networkAuthenticationRequired(String string, String string2) {
        return Results.status(511, string, string2);
    }

    public static Result networkAuthenticationRequired(JsonNode jsonNode) {
        return Results.status(511, jsonNode);
    }

    public static Result networkAuthenticationRequired(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        return Results.status(511, jsonNode, jsonEncoding);
    }

    public static Result networkAuthenticationRequired(byte[] byArray) {
        return Results.status(511, byArray);
    }

    public static Result networkAuthenticationRequired(InputStream inputStream) {
        return Results.status(511, inputStream);
    }

    public static Result networkAuthenticationRequired(InputStream inputStream, long l) {
        return Results.status(511, inputStream, l);
    }

    public static Result networkAuthenticationRequired(File file) {
        return Results.networkAuthenticationRequired(file, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result networkAuthenticationRequired(File file, FileMimeTypes fileMimeTypes) {
        return Results.status(511, file, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(File file, boolean bl) {
        return Results.networkAuthenticationRequired(file, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result networkAuthenticationRequired(File file, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(511, file, bl, fileMimeTypes);
    }

    @Deprecated
    public static Result networkAuthenticationRequired(File file, String string) {
        return Results.networkAuthenticationRequired(file, Optional.ofNullable(string));
    }

    public static Result networkAuthenticationRequired(File file, Optional<String> optional) {
        return Results.networkAuthenticationRequired(file, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    @Deprecated
    public static Result networkAuthenticationRequired(File file, String string, FileMimeTypes fileMimeTypes) {
        return Results.networkAuthenticationRequired(file, Optional.ofNullable(string), fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(File file, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(511, file, optional, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(File file, boolean bl, Optional<String> optional) {
        return Results.status(511, file, bl, optional);
    }

    public static Result networkAuthenticationRequired(File file, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(511, file, bl, optional, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(Path path) {
        return Results.networkAuthenticationRequired(path, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result networkAuthenticationRequired(Path path, FileMimeTypes fileMimeTypes) {
        return Results.status(511, path, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(Path path, boolean bl) {
        return Results.networkAuthenticationRequired(path, bl, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result networkAuthenticationRequired(Path path, boolean bl, FileMimeTypes fileMimeTypes) {
        return Results.status(511, path, bl, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(Path path, Optional<String> optional) {
        return Results.networkAuthenticationRequired(path, optional, StaticFileMimeTypes.fileMimeTypes());
    }

    public static Result networkAuthenticationRequired(Path path, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(511, path, optional, fileMimeTypes);
    }

    public static Result networkAuthenticationRequired(Path path, boolean bl, Optional<String> optional) {
        return Results.status(511, path, bl, optional);
    }

    public static Result networkAuthenticationRequired(Path path, boolean bl, Optional<String> optional, FileMimeTypes fileMimeTypes) {
        return Results.status(511, path, bl, optional, fileMimeTypes);
    }

    public static Result movedPermanently(String string) {
        return new Result(301, Collections.singletonMap("Location", string));
    }

    public static Result movedPermanently(Call call) {
        return new Result(301, Collections.singletonMap("Location", call.path()));
    }

    public static Result found(String string) {
        return new Result(302, Collections.singletonMap("Location", string));
    }

    public static Result found(Call call) {
        return new Result(302, Collections.singletonMap("Location", call.path()));
    }

    public static Result seeOther(String string) {
        return new Result(303, Collections.singletonMap("Location", string));
    }

    public static Result seeOther(Call call) {
        return new Result(303, Collections.singletonMap("Location", call.path()));
    }

    public static Result redirect(String string) {
        return new Result(303, Collections.singletonMap("Location", string));
    }

    public static Result redirect(String string, Map<String, List<String>> map2) {
        String string2 = Results$.MODULE$.addQueryStringParams(string, JavaHelpers.javaMapOfListToImmutableScalaMapOfSeq(map2));
        return new Result(303, Collections.singletonMap("Location", string2));
    }

    public static Result redirect(Call call) {
        return new Result(303, Collections.singletonMap("Location", call.path()));
    }

    public static Result temporaryRedirect(String string) {
        return new Result(307, Collections.singletonMap("Location", string));
    }

    public static Result temporaryRedirect(Call call) {
        return new Result(307, Collections.singletonMap("Location", call.path()));
    }

    public static Result permanentRedirect(String string) {
        return new Result(308, Collections.singletonMap("Location", string));
    }

    public static Result permanentRedirect(Call call) {
        return new Result(308, Collections.singletonMap("Location", call.path()));
    }
}

