/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import play.api.mvc.Cookie;
import play.api.mvc.DiscardingCookie;
import play.api.mvc.Flash;
import play.api.mvc.Session;
import play.core.j.JavaHelpers$;
import play.core.j.JavaResultExtractor;
import play.http.HttpEntity;
import play.i18n.Lang;
import play.i18n.MessagesApi;
import play.libs.Scala;
import play.libs.typedmap.TypedEntry;
import play.libs.typedmap.TypedKey;
import play.libs.typedmap.TypedMap;
import play.mvc.Http;
import play.mvc.ResponseHeader;
import scala.Option;

public class Result {
    private static final Pattern SPLIT_CHARSET = Pattern.compile("(?i);\\s*charset=");
    private final ResponseHeader header;
    private final HttpEntity body;
    private final Http.Flash flash;
    private final Http.Session session;
    private final List<Http.Cookie> cookies;
    private final TypedMap attrs;

    public Result(ResponseHeader responseHeader, HttpEntity httpEntity, Http.Session session, Http.Flash flash, List<Http.Cookie> list, TypedMap typedMap) {
        this.header = responseHeader;
        this.body = httpEntity;
        this.session = session;
        this.flash = flash;
        this.cookies = list;
        this.attrs = typedMap;
    }

    public Result(ResponseHeader responseHeader, HttpEntity httpEntity, Http.Session session, Http.Flash flash, List<Http.Cookie> list) {
        this(responseHeader, httpEntity, session, flash, list, TypedMap.empty());
    }

    public Result(ResponseHeader responseHeader, HttpEntity httpEntity) {
        this(responseHeader, httpEntity, null, null, Collections.emptyList());
    }

    public Result(int n, String string, Map<String, String> map2, HttpEntity httpEntity) {
        this(new ResponseHeader(n, map2, string), httpEntity);
    }

    public Result(int n, Map<String, String> map2, HttpEntity httpEntity) {
        this(n, null, map2, httpEntity);
    }

    public Result(int n, Map<String, String> map2) {
        this(n, null, map2, HttpEntity.NO_ENTITY);
    }

    public Result(int n, HttpEntity httpEntity) {
        this(n, null, Collections.emptyMap(), httpEntity);
    }

    public Result(int n) {
        this(n, null, Collections.emptyMap(), HttpEntity.NO_ENTITY);
    }

    public int status() {
        return this.header.status();
    }

    public Optional<String> reasonPhrase() {
        return this.header.reasonPhrase();
    }

    protected ResponseHeader getHeader() {
        return this.header;
    }

    public HttpEntity body() {
        return this.body;
    }

    public Optional<String> redirectLocation() {
        return this.header("Location");
    }

    public Optional<String> header(String string) {
        return this.header.getHeader(string);
    }

    public Map<String, String> headers() {
        return this.header.headers();
    }

    public Optional<String> contentType() {
        return this.body.contentType().map(string -> {
            if (string.contains(";")) {
                return string.substring(0, string.indexOf(59)).trim();
            }
            return string.trim();
        });
    }

    public Optional<String> charset() {
        return this.body.contentType().flatMap(string -> {
            String[] stringArray = SPLIT_CHARSET.split((CharSequence)string, 2);
            if (stringArray.length > 1) {
                String string2 = stringArray[1];
                return Optional.of(string2.trim());
            }
            return Optional.empty();
        });
    }

    public Http.Flash flash() {
        return this.flash;
    }

    public Result withFlash(Http.Flash flash) {
        play.api.mvc.Result.warnFlashingIfNotRedirect(flash.asScala(), this.header.asScala());
        return new Result(this.header, this.body, this.session, flash, this.cookies);
    }

    public Result withFlash(Map<String, String> map2) {
        return this.withFlash(new Http.Flash(map2));
    }

    public Result withNewFlash() {
        return this.withFlash(Collections.emptyMap());
    }

    public Result flashing(Map<String, String> map2) {
        if (this.flash == null) {
            return this.withFlash(map2);
        }
        return this.withFlash(this.flash.adding(map2));
    }

    public Result flashing(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(string, string2);
        return this.flashing(hashMap);
    }

    public Result removingFromFlash(String ... stringArray) {
        if (this.flash == null) {
            return this.withNewFlash();
        }
        return this.withFlash(this.flash.removing(stringArray));
    }

    public Http.Session session() {
        return this.session;
    }

    public Http.Session session(Http.Request request) {
        if (this.session != null) {
            return this.session;
        }
        return request.session();
    }

    public Result withSession(Http.Session session) {
        return new Result(this.header, this.body, session, this.flash, this.cookies);
    }

    public Result withSession(Map<String, String> map2) {
        return this.withSession(new Http.Session(map2));
    }

    public Result withNewSession() {
        return this.withSession(Collections.emptyMap());
    }

    public Result addingToSession(Http.Request request, Map<String, String> map2) {
        return this.withSession(this.session(request).adding(map2));
    }

    public Result addingToSession(Http.Request request, String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put(string, string2);
        return this.addingToSession(request, hashMap);
    }

    public Result removingFromSession(Http.Request request, String ... stringArray) {
        return this.withSession(this.session(request).removing(stringArray));
    }

    public Optional<Http.Cookie> cookie(String string) {
        return this.cookies().get(string);
    }

    @Deprecated
    public Optional<Http.Cookie> getCookie(String string) {
        return this.cookie(string);
    }

    public Http.Cookies cookies() {
        return new Http.Cookies(){

            @Override
            public Optional<Http.Cookie> get(String string) {
                return Result.this.cookies.stream().filter(cookie -> cookie.name().equals(string)).findFirst();
            }

            @Override
            public Iterator<Http.Cookie> iterator() {
                return Result.this.cookies.iterator();
            }
        };
    }

    public Result withCookies(Http.Cookie ... cookieArray) {
        List<Http.Cookie> list = Stream.concat(this.cookies.stream().filter(cookie -> {
            for (Http.Cookie cookie2 : cookieArray) {
                if (!cookie.name().equals(cookie2.name())) continue;
                return false;
            }
            return true;
        }), Stream.of(cookieArray)).collect(Collectors.toList());
        return new Result(this.header, this.body, this.session, this.flash, list);
    }

    public Result discardingCookie(String string) {
        return this.discardingCookie(string, "/", null, false);
    }

    public Result discardingCookie(String string, String string2) {
        return this.discardingCookie(string, string2, null, false);
    }

    public Result discardingCookie(String string, String string2, String string3) {
        return this.discardingCookie(string, string2, string3, false);
    }

    public Result discardingCookie(String string, String string2, String string3, boolean bl) {
        return this.discardingCookie(string, string2, string3, bl, null);
    }

    public Result discardingCookie(String string, String string2, String string3, boolean bl, Http.Cookie.SameSite sameSite) {
        return this.withCookies(new DiscardingCookie(string, string2, (Option<String>)Option.apply((Object)string3), bl, (Option<Cookie.SameSite>)Option.apply((Object)((Object)sameSite)).map(Http.Cookie.SameSite::asScala)).toCookie().asJava());
    }

    public Result withHeader(String string, String string2) {
        return new Result(this.header.withHeader(string, string2), this.body, this.session, this.flash, this.cookies);
    }

    public Result withHeaders(String ... stringArray) {
        return new Result(JavaResultExtractor.withHeader(this.header, stringArray), this.body, this.session, this.flash, this.cookies);
    }

    public Result withoutHeader(String string) {
        return new Result(this.header.withoutHeader(string), this.body, this.session, this.flash, this.cookies);
    }

    public Result as(String string) {
        return new Result(this.header, this.body.as(string), this.session, this.flash, this.cookies);
    }

    public Result withLang(Lang lang, MessagesApi messagesApi) {
        return messagesApi.setLang(this, lang);
    }

    public Result withLang(Locale locale, MessagesApi messagesApi) {
        return this.withLang(new Lang(locale), messagesApi);
    }

    public Result withoutLang(MessagesApi messagesApi) {
        return messagesApi.clearLang(this);
    }

    public TypedMap attrs() {
        return this.attrs;
    }

    public Result withAttrs(TypedMap typedMap) {
        return new Result(this.header, this.body, this.session, this.flash, this.cookies, typedMap);
    }

    public <A> Result addAttr(TypedKey<A> typedKey, A a) {
        return this.withAttrs(this.attrs.put(typedKey, a));
    }

    public Result addAttrs(TypedEntry<?> typedEntry) {
        return this.withAttrs(this.attrs.putAll(typedEntry));
    }

    public Result addAttrs(TypedEntry<?> typedEntry, TypedEntry<?> typedEntry2) {
        return this.withAttrs(this.attrs.putAll(typedEntry, typedEntry2));
    }

    public Result addAttrs(TypedEntry<?> typedEntry, TypedEntry<?> typedEntry2, TypedEntry<?> typedEntry3) {
        return this.withAttrs(this.attrs.putAll(typedEntry, typedEntry2, typedEntry3));
    }

    public Result addAttrs(TypedEntry<?> ... typedEntryArray) {
        return this.withAttrs(this.attrs.putAll(typedEntryArray));
    }

    public Result addAttrs(List<TypedEntry<?>> list) {
        return this.withAttrs(this.attrs.putAll(list));
    }

    public Result removeAttr(TypedKey<?> typedKey) {
        return this.withAttrs(this.attrs.remove(typedKey));
    }

    public play.api.mvc.Result asScala() {
        return new play.api.mvc.Result(this.header.asScala(), this.body.asScala(), (Option<Session>)(this.session == null ? Scala.None() : Scala.Option(Session.fromJavaSession(this.session))), (Option<Flash>)(this.flash == null ? Scala.None() : Scala.Option(Flash.fromJavaFlash(this.flash))), JavaHelpers$.MODULE$.cookiesToScalaCookies(this.cookies), this.attrs.asScala());
    }
}

