/*
 * Decompiled with CFR 0.152.
 */
package play.libs.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import play.libs.reflect.MemberUtils;

public class ConstructorUtils {
    private static <T> T notNull(T t, String string, Object ... objectArray) {
        if (t == null) {
            throw new NullPointerException(String.format(string, objectArray));
        }
        return t;
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> constructor) {
        ConstructorUtils.notNull(constructor, "constructor cannot be null", new Object[0]);
        return MemberUtils.isAccessible(constructor) && ConstructorUtils.isAccessible(constructor.getDeclaringClass()) ? constructor : null;
    }

    public static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?> ... classArray) {
        ConstructorUtils.notNull(clazz, "class cannot be null", new Object[0]);
        try {
            Constructor<T> constructor = clazz.getConstructor(classArray);
            MemberUtils.setAccessibleWorkaround(constructor);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor<?>[] constructorArray;
            Constructor<?> constructor = null;
            for (Constructor<?> constructor2 : constructorArray = clazz.getConstructors()) {
                Constructor<?> constructor3;
                if (!MemberUtils.isMatchingConstructor(constructor2, classArray) || (constructor2 = ConstructorUtils.getAccessibleConstructor(constructor2)) == null) continue;
                MemberUtils.setAccessibleWorkaround(constructor2);
                if (constructor != null && MemberUtils.compareConstructorFit(constructor2, constructor, classArray) >= 0) continue;
                constructor = constructor3 = constructor2;
            }
            return constructor;
        }
    }

    private static boolean isAccessible(Class<?> clazz) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getEnclosingClass()) {
            if (Modifier.isPublic(clazz2.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

