/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.sslconfig.ssl.SSLConfigParser;
import com.typesafe.sslconfig.ssl.SSLConfigSettings;
import com.typesafe.sslconfig.util.EnrichedConfig$;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import play.api.libs.ws.WSClientConfig;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u00113AAB\u0004\u0001!!AQ\u0005\u0001B\u0001B\u0003%a\u0005\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0015a\u0004\u0001\"\u0001>\u0011!q\u0004\u0001#b\u0001\n\u0003z$AD,T\u0007>tg-[4QCJ\u001cXM\u001d\u0006\u0003\u0011%\t!a^:\u000b\u0005)Y\u0011\u0001\u00027jENT!\u0001D\u0007\u0002\u0007\u0005\u0004\u0018NC\u0001\u000f\u0003\u0011\u0001H.Y=\u0004\u0001M\u0019\u0001!E\r\u0011\u0005I9R\"A\n\u000b\u0005Q)\u0012\u0001\u00027b]\u001eT\u0011AF\u0001\u0005U\u00064\u0018-\u0003\u0002\u0019'\t1qJ\u00196fGR\u00042AG\u0010\"\u001b\u0005Y\"B\u0001\u000f\u001e\u0003\u0019IgN[3di*\ta$A\u0004kC.\f'\u000f^1\n\u0005\u0001Z\"\u0001\u0003)s_ZLG-\u001a:\u0011\u0005\t\u001aS\"A\u0004\n\u0005\u0011:!AD,T\u00072LWM\u001c;D_:4\u0017nZ\u0001\u0007G>tg-[4\u0011\u0005\u001djS\"\u0001\u0015\u000b\u0005\u0015J#B\u0001\u0016,\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0017\u0002\u0007\r|W.\u0003\u0002/Q\t11i\u001c8gS\u001e\f1b\u00197bgNdu.\u00193feB\u0011!#M\u0005\u0003eM\u00111b\u00117bgNdu.\u00193fe\u00061A(\u001b8jiz\"2!\u000e\u001c8!\t\u0011\u0003\u0001C\u0003&\u0007\u0001\u0007a\u0005C\u00030\u0007\u0001\u0007\u0001\u0007\u000b\u0002\u0004sA\u0011!DO\u0005\u0003wm\u0011a!\u00138kK\u000e$\u0018!\u00029beN,G#A\u0011\u0002\u0007\u001d,G/F\u0001\"Q\t\u0001\u0011\t\u0005\u0002\u001b\u0005&\u00111i\u0007\u0002\n'&tw\r\\3u_:\u0004")
public class WSConfigParser
implements Provider<WSClientConfig> {
    private WSClientConfig get;
    private final Config config;
    private final ClassLoader classLoader;
    private volatile boolean bitmap$0;

    public WSClientConfig parse() {
        Some some;
        Config wsConfig = this.config.getConfig("play.ws");
        Duration connectionTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.connection"));
        Duration idleTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.idle"));
        Duration requestTimeout = Duration$.MODULE$.apply(wsConfig.getString("timeout.request"));
        boolean followRedirects = wsConfig.getBoolean("followRedirects");
        boolean useProxyProperties = wsConfig.getBoolean("useProxyProperties");
        try {
            some = new Some((Object)wsConfig.getString("useragent"));
        }
        catch (ConfigException.Null e) {
            some = None$.MODULE$;
        }
        Some userAgent = some;
        boolean compressionEnabled = wsConfig.getBoolean("compressionEnabled");
        SSLConfigSettings sslConfig = new SSLConfigParser(EnrichedConfig$.MODULE$.apply(wsConfig.getConfig("ssl")), this.classLoader).parse();
        return new WSClientConfig(connectionTimeout, idleTimeout, requestTimeout, followRedirects, useProxyProperties, (Option<String>)userAgent, compressionEnabled, sslConfig);
    }

    private WSClientConfig get$lzycompute() {
        WSConfigParser wSConfigParser = this;
        synchronized (wSConfigParser) {
            if (!this.bitmap$0) {
                this.get = this.parse();
                this.bitmap$0 = true;
            }
        }
        return this.get;
    }

    public WSClientConfig get() {
        if (!this.bitmap$0) {
            return this.get$lzycompute();
        }
        return this.get;
    }

    @Inject
    public WSConfigParser(Config config, ClassLoader classLoader) {
        this.config = config;
        this.classLoader = classLoader;
    }
}

