package play.api.libs.json

trait GeneratedReads {
  implicit def Tuple1R[T1: Reads]: Reads[Tuple1[T1]] = Reads[Tuple1[T1]] {
    case JsArray(arr) if arr.size == 1 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
      } yield Tuple1(t1)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 1 elements"))))
  }
  implicit def Tuple2R[T1: Reads, T2: Reads]: Reads[Tuple2[T1, T2]] = Reads[Tuple2[T1, T2]] {
    case JsArray(arr) if arr.size == 2 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
      } yield Tuple2(t1, t2)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 2 elements"))))
  }
  implicit def Tuple3R[T1: Reads, T2: Reads, T3: Reads]: Reads[Tuple3[T1, T2, T3]] = Reads[Tuple3[T1, T2, T3]] {
    case JsArray(arr) if arr.size == 3 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
      } yield Tuple3(t1, t2, t3)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 3 elements"))))
  }
  implicit def Tuple4R[T1: Reads, T2: Reads, T3: Reads, T4: Reads]: Reads[Tuple4[T1, T2, T3, T4]] = Reads[Tuple4[T1, T2, T3, T4]] {
    case JsArray(arr) if arr.size == 4 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
      } yield Tuple4(t1, t2, t3, t4)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 4 elements"))))
  }
  implicit def Tuple5R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads]: Reads[Tuple5[T1, T2, T3, T4, T5]] = Reads[Tuple5[T1, T2, T3, T4, T5]] {
    case JsArray(arr) if arr.size == 5 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
      } yield Tuple5(t1, t2, t3, t4, t5)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 5 elements"))))
  }
  implicit def Tuple6R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads]: Reads[Tuple6[T1, T2, T3, T4, T5, T6]] = Reads[Tuple6[T1, T2, T3, T4, T5, T6]] {
    case JsArray(arr) if arr.size == 6 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
      } yield Tuple6(t1, t2, t3, t4, t5, t6)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 6 elements"))))
  }
  implicit def Tuple7R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads]: Reads[Tuple7[T1, T2, T3, T4, T5, T6, T7]] = Reads[Tuple7[T1, T2, T3, T4, T5, T6, T7]] {
    case JsArray(arr) if arr.size == 7 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
      } yield Tuple7(t1, t2, t3, t4, t5, t6, t7)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 7 elements"))))
  }
  implicit def Tuple8R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads]: Reads[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]] = Reads[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]] {
    case JsArray(arr) if arr.size == 8 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
      } yield Tuple8(t1, t2, t3, t4, t5, t6, t7, t8)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 8 elements"))))
  }
  implicit def Tuple9R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads]: Reads[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]] = Reads[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]] {
    case JsArray(arr) if arr.size == 9 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
      } yield Tuple9(t1, t2, t3, t4, t5, t6, t7, t8, t9)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 9 elements"))))
  }
  implicit def Tuple10R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads]: Reads[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]] = Reads[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]] {
    case JsArray(arr) if arr.size == 10 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
      } yield Tuple10(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 10 elements"))))
  }
  implicit def Tuple11R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads]: Reads[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]] = Reads[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]] {
    case JsArray(arr) if arr.size == 11 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
      } yield Tuple11(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 11 elements"))))
  }
  implicit def Tuple12R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads]: Reads[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]] = Reads[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]] {
    case JsArray(arr) if arr.size == 12 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
      } yield Tuple12(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 12 elements"))))
  }
  implicit def Tuple13R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads]: Reads[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]] = Reads[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]] {
    case JsArray(arr) if arr.size == 13 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
      } yield Tuple13(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 13 elements"))))
  }
  implicit def Tuple14R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads]: Reads[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]] = Reads[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]] {
    case JsArray(arr) if arr.size == 14 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
      } yield Tuple14(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 14 elements"))))
  }
  implicit def Tuple15R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads]: Reads[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]] = Reads[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]] {
    case JsArray(arr) if arr.size == 15 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
      } yield Tuple15(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 15 elements"))))
  }
  implicit def Tuple16R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads]: Reads[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]] = Reads[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]] {
    case JsArray(arr) if arr.size == 16 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
      } yield Tuple16(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 16 elements"))))
  }
  implicit def Tuple17R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads]: Reads[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]] = Reads[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]] {
    case JsArray(arr) if arr.size == 17 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
      } yield Tuple17(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 17 elements"))))
  }
  implicit def Tuple18R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads, T18: Reads]: Reads[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]] = Reads[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]] {
    case JsArray(arr) if arr.size == 18 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
        t18 <- implicitly[Reads[T18]].reads(arr(17))
      } yield Tuple18(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 18 elements"))))
  }
  implicit def Tuple19R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads, T18: Reads, T19: Reads]: Reads[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]] = Reads[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]] {
    case JsArray(arr) if arr.size == 19 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
        t18 <- implicitly[Reads[T18]].reads(arr(17))
        t19 <- implicitly[Reads[T19]].reads(arr(18))
      } yield Tuple19(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 19 elements"))))
  }
  implicit def Tuple20R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads, T18: Reads, T19: Reads, T20: Reads]: Reads[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]] = Reads[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]] {
    case JsArray(arr) if arr.size == 20 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
        t18 <- implicitly[Reads[T18]].reads(arr(17))
        t19 <- implicitly[Reads[T19]].reads(arr(18))
        t20 <- implicitly[Reads[T20]].reads(arr(19))
      } yield Tuple20(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19, t20)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 20 elements"))))
  }
  implicit def Tuple21R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads, T18: Reads, T19: Reads, T20: Reads, T21: Reads]: Reads[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]] = Reads[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]] {
    case JsArray(arr) if arr.size == 21 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
        t18 <- implicitly[Reads[T18]].reads(arr(17))
        t19 <- implicitly[Reads[T19]].reads(arr(18))
        t20 <- implicitly[Reads[T20]].reads(arr(19))
        t21 <- implicitly[Reads[T21]].reads(arr(20))
      } yield Tuple21(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19, t20, t21)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 21 elements"))))
  }
  implicit def Tuple22R[T1: Reads, T2: Reads, T3: Reads, T4: Reads, T5: Reads, T6: Reads, T7: Reads, T8: Reads, T9: Reads, T10: Reads, T11: Reads, T12: Reads, T13: Reads, T14: Reads, T15: Reads, T16: Reads, T17: Reads, T18: Reads, T19: Reads, T20: Reads, T21: Reads, T22: Reads]: Reads[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]] = Reads[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]] {
    case JsArray(arr) if arr.size == 22 =>
      for {
        t1 <- implicitly[Reads[T1]].reads(arr(0))
        t2 <- implicitly[Reads[T2]].reads(arr(1))
        t3 <- implicitly[Reads[T3]].reads(arr(2))
        t4 <- implicitly[Reads[T4]].reads(arr(3))
        t5 <- implicitly[Reads[T5]].reads(arr(4))
        t6 <- implicitly[Reads[T6]].reads(arr(5))
        t7 <- implicitly[Reads[T7]].reads(arr(6))
        t8 <- implicitly[Reads[T8]].reads(arr(7))
        t9 <- implicitly[Reads[T9]].reads(arr(8))
        t10 <- implicitly[Reads[T10]].reads(arr(9))
        t11 <- implicitly[Reads[T11]].reads(arr(10))
        t12 <- implicitly[Reads[T12]].reads(arr(11))
        t13 <- implicitly[Reads[T13]].reads(arr(12))
        t14 <- implicitly[Reads[T14]].reads(arr(13))
        t15 <- implicitly[Reads[T15]].reads(arr(14))
        t16 <- implicitly[Reads[T16]].reads(arr(15))
        t17 <- implicitly[Reads[T17]].reads(arr(16))
        t18 <- implicitly[Reads[T18]].reads(arr(17))
        t19 <- implicitly[Reads[T19]].reads(arr(18))
        t20 <- implicitly[Reads[T20]].reads(arr(19))
        t21 <- implicitly[Reads[T21]].reads(arr(20))
        t22 <- implicitly[Reads[T22]].reads(arr(21))
      } yield Tuple22(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11, t12, t13, t14, t15, t16, t17, t18, t19, t20, t21, t22)

    case _ =>
      JsError(Seq(JsPath() -> Seq(JsonValidationError("Expected array of 22 elements"))))
  }
}

trait GeneratedWrites{
  implicit def Tuple1W[T1: Writes]: Writes[Tuple1[T1]] = Writes[Tuple1[T1]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1)))
  )
  implicit def Tuple2W[T1: Writes, T2: Writes]: Writes[Tuple2[T1, T2]] = Writes[Tuple2[T1, T2]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2)))
  )
  implicit def Tuple3W[T1: Writes, T2: Writes, T3: Writes]: Writes[Tuple3[T1, T2, T3]] = Writes[Tuple3[T1, T2, T3]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3)))
  )
  implicit def Tuple4W[T1: Writes, T2: Writes, T3: Writes, T4: Writes]: Writes[Tuple4[T1, T2, T3, T4]] = Writes[Tuple4[T1, T2, T3, T4]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4)))
  )
  implicit def Tuple5W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes]: Writes[Tuple5[T1, T2, T3, T4, T5]] = Writes[Tuple5[T1, T2, T3, T4, T5]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5)))
  )
  implicit def Tuple6W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes]: Writes[Tuple6[T1, T2, T3, T4, T5, T6]] = Writes[Tuple6[T1, T2, T3, T4, T5, T6]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6)))
  )
  implicit def Tuple7W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes]: Writes[Tuple7[T1, T2, T3, T4, T5, T6, T7]] = Writes[Tuple7[T1, T2, T3, T4, T5, T6, T7]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7)))
  )
  implicit def Tuple8W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes]: Writes[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]] = Writes[Tuple8[T1, T2, T3, T4, T5, T6, T7, T8]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8)))
  )
  implicit def Tuple9W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes]: Writes[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]] = Writes[Tuple9[T1, T2, T3, T4, T5, T6, T7, T8, T9]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9)))
  )
  implicit def Tuple10W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes]: Writes[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]] = Writes[Tuple10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10)))
  )
  implicit def Tuple11W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes]: Writes[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]] = Writes[Tuple11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11)))
  )
  implicit def Tuple12W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes]: Writes[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]] = Writes[Tuple12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12)))
  )
  implicit def Tuple13W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes]: Writes[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]] = Writes[Tuple13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13)))
  )
  implicit def Tuple14W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes]: Writes[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]] = Writes[Tuple14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14)))
  )
  implicit def Tuple15W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes]: Writes[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]] = Writes[Tuple15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15)))
  )
  implicit def Tuple16W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes]: Writes[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]] = Writes[Tuple16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16)))
  )
  implicit def Tuple17W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes]: Writes[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]] = Writes[Tuple17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17)))
  )
  implicit def Tuple18W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes, T18: Writes]: Writes[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]] = Writes[Tuple18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17), implicitly[Writes[T18]].writes(x._18)))
  )
  implicit def Tuple19W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes, T18: Writes, T19: Writes]: Writes[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]] = Writes[Tuple19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17), implicitly[Writes[T18]].writes(x._18), implicitly[Writes[T19]].writes(x._19)))
  )
  implicit def Tuple20W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes, T18: Writes, T19: Writes, T20: Writes]: Writes[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]] = Writes[Tuple20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17), implicitly[Writes[T18]].writes(x._18), implicitly[Writes[T19]].writes(x._19), implicitly[Writes[T20]].writes(x._20)))
  )
  implicit def Tuple21W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes, T18: Writes, T19: Writes, T20: Writes, T21: Writes]: Writes[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]] = Writes[Tuple21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17), implicitly[Writes[T18]].writes(x._18), implicitly[Writes[T19]].writes(x._19), implicitly[Writes[T20]].writes(x._20), implicitly[Writes[T21]].writes(x._21)))
  )
  implicit def Tuple22W[T1: Writes, T2: Writes, T3: Writes, T4: Writes, T5: Writes, T6: Writes, T7: Writes, T8: Writes, T9: Writes, T10: Writes, T11: Writes, T12: Writes, T13: Writes, T14: Writes, T15: Writes, T16: Writes, T17: Writes, T18: Writes, T19: Writes, T20: Writes, T21: Writes, T22: Writes]: Writes[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]] = Writes[Tuple22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]](
    x => JsArray(Array(implicitly[Writes[T1]].writes(x._1), implicitly[Writes[T2]].writes(x._2), implicitly[Writes[T3]].writes(x._3), implicitly[Writes[T4]].writes(x._4), implicitly[Writes[T5]].writes(x._5), implicitly[Writes[T6]].writes(x._6), implicitly[Writes[T7]].writes(x._7), implicitly[Writes[T8]].writes(x._8), implicitly[Writes[T9]].writes(x._9), implicitly[Writes[T10]].writes(x._10), implicitly[Writes[T11]].writes(x._11), implicitly[Writes[T12]].writes(x._12), implicitly[Writes[T13]].writes(x._13), implicitly[Writes[T14]].writes(x._14), implicitly[Writes[T15]].writes(x._15), implicitly[Writes[T16]].writes(x._16), implicitly[Writes[T17]].writes(x._17), implicitly[Writes[T18]].writes(x._18), implicitly[Writes[T19]].writes(x._19), implicitly[Writes[T20]].writes(x._20), implicitly[Writes[T21]].writes(x._21), implicitly[Writes[T22]].writes(x._22)))
  )
}
