/*
 * Decompiled with CFR 0.152.
 */
package play.cache;

import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import play.cache.AsyncCacheApi;
import play.cache.SyncCacheApi;

public class DefaultSyncCacheApi
implements SyncCacheApi {
    private final AsyncCacheApi cacheApi;
    protected long awaitTimeoutMillis = 5000L;

    @Inject
    public DefaultSyncCacheApi(AsyncCacheApi asyncCacheApi) {
        this.cacheApi = asyncCacheApi;
    }

    @Override
    public <T> Optional<T> get(String string) {
        return this.blocking(this.cacheApi.get(string));
    }

    @Override
    public <T> T getOrElseUpdate(String string, Callable<T> callable, int n) {
        return this.blocking(this.cacheApi.getOrElseUpdate(string, () -> CompletableFuture.completedFuture(callable.call()), n));
    }

    @Override
    public <T> T getOrElseUpdate(String string, Callable<T> callable) {
        return this.blocking(this.cacheApi.getOrElseUpdate(string, () -> CompletableFuture.completedFuture(callable.call())));
    }

    @Override
    public void set(String string, Object object, int n) {
        this.blocking(this.cacheApi.set(string, object, n));
    }

    @Override
    public void set(String string, Object object) {
        this.blocking(this.cacheApi.set(string, object));
    }

    @Override
    public void remove(String string) {
        this.blocking(this.cacheApi.remove(string));
    }

    private <T> T blocking(CompletionStage<T> completionStage) {
        boolean bl = false;
        while (true) {
            try {
                T t = completionStage.toCompletableFuture().get(this.awaitTimeoutMillis, TimeUnit.MILLISECONDS);
                return t;
            }
            catch (InterruptedException interruptedException) {
                try {
                    bl = true;
                    continue;
                }
                catch (ExecutionException | TimeoutException exception) {
                    throw new RuntimeException(exception);
                }
            }
            break;
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

